/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.DeriveKeyUsage;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes;
import software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin;
import software.amazon.awssdk.services.paymentcryptography.model.KeyState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Key
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Key> {
    private static final SdkField<String> KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyArn").getter(Key.getter(Key::keyArn)).setter(Key.setter(Builder::keyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyArn").build()}).build();
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyAttributes").getter(Key.getter(Key::keyAttributes)).setter(Key.setter(Builder::keyAttributes)).constructor(KeyAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValue").getter(Key.getter(Key::keyCheckValue)).setter(Key.setter(Builder::keyCheckValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValue").build()}).build();
    private static final SdkField<String> KEY_CHECK_VALUE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyCheckValueAlgorithm").getter(Key.getter(Key::keyCheckValueAlgorithmAsString)).setter(Key.setter(Builder::keyCheckValueAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCheckValueAlgorithm").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(Key.getter(Key::enabled)).setter(Key.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> EXPORTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Exportable").getter(Key.getter(Key::exportable)).setter(Key.setter(Builder::exportable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exportable").build()}).build();
    private static final SdkField<String> KEY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyState").getter(Key.getter(Key::keyStateAsString)).setter(Key.setter(Builder::keyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyState").build()}).build();
    private static final SdkField<String> KEY_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyOrigin").getter(Key.getter(Key::keyOriginAsString)).setter(Key.setter(Builder::keyOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyOrigin").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTimestamp").getter(Key.getter(Key::createTimestamp)).setter(Key.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<Instant> USAGE_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UsageStartTimestamp").getter(Key.getter(Key::usageStartTimestamp)).setter(Key.setter(Builder::usageStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageStartTimestamp").build()}).build();
    private static final SdkField<Instant> USAGE_STOP_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UsageStopTimestamp").getter(Key.getter(Key::usageStopTimestamp)).setter(Key.setter(Builder::usageStopTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageStopTimestamp").build()}).build();
    private static final SdkField<Instant> DELETE_PENDING_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletePendingTimestamp").getter(Key.getter(Key::deletePendingTimestamp)).setter(Key.setter(Builder::deletePendingTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletePendingTimestamp").build()}).build();
    private static final SdkField<Instant> DELETE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTimestamp").getter(Key.getter(Key::deleteTimestamp)).setter(Key.setter(Builder::deleteTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTimestamp").build()}).build();
    private static final SdkField<String> DERIVE_KEY_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeriveKeyUsage").getter(Key.getter(Key::deriveKeyUsageAsString)).setter(Key.setter(Builder::deriveKeyUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeriveKeyUsage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ARN_FIELD, KEY_ATTRIBUTES_FIELD, KEY_CHECK_VALUE_FIELD, KEY_CHECK_VALUE_ALGORITHM_FIELD, ENABLED_FIELD, EXPORTABLE_FIELD, KEY_STATE_FIELD, KEY_ORIGIN_FIELD, CREATE_TIMESTAMP_FIELD, USAGE_START_TIMESTAMP_FIELD, USAGE_STOP_TIMESTAMP_FIELD, DELETE_PENDING_TIMESTAMP_FIELD, DELETE_TIMESTAMP_FIELD, DERIVE_KEY_USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Key.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyArn;
    private final KeyAttributes keyAttributes;
    private final String keyCheckValue;
    private final String keyCheckValueAlgorithm;
    private final Boolean enabled;
    private final Boolean exportable;
    private final String keyState;
    private final String keyOrigin;
    private final Instant createTimestamp;
    private final Instant usageStartTimestamp;
    private final Instant usageStopTimestamp;
    private final Instant deletePendingTimestamp;
    private final Instant deleteTimestamp;
    private final String deriveKeyUsage;

    private Key(BuilderImpl builder) {
        this.keyArn = builder.keyArn;
        this.keyAttributes = builder.keyAttributes;
        this.keyCheckValue = builder.keyCheckValue;
        this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
        this.enabled = builder.enabled;
        this.exportable = builder.exportable;
        this.keyState = builder.keyState;
        this.keyOrigin = builder.keyOrigin;
        this.createTimestamp = builder.createTimestamp;
        this.usageStartTimestamp = builder.usageStartTimestamp;
        this.usageStopTimestamp = builder.usageStopTimestamp;
        this.deletePendingTimestamp = builder.deletePendingTimestamp;
        this.deleteTimestamp = builder.deleteTimestamp;
        this.deriveKeyUsage = builder.deriveKeyUsage;
    }

    public final String keyArn() {
        return this.keyArn;
    }

    public final KeyAttributes keyAttributes() {
        return this.keyAttributes;
    }

    public final String keyCheckValue() {
        return this.keyCheckValue;
    }

    public final KeyCheckValueAlgorithm keyCheckValueAlgorithm() {
        return KeyCheckValueAlgorithm.fromValue(this.keyCheckValueAlgorithm);
    }

    public final String keyCheckValueAlgorithmAsString() {
        return this.keyCheckValueAlgorithm;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean exportable() {
        return this.exportable;
    }

    public final KeyState keyState() {
        return KeyState.fromValue(this.keyState);
    }

    public final String keyStateAsString() {
        return this.keyState;
    }

    public final KeyOrigin keyOrigin() {
        return KeyOrigin.fromValue(this.keyOrigin);
    }

    public final String keyOriginAsString() {
        return this.keyOrigin;
    }

    public final Instant createTimestamp() {
        return this.createTimestamp;
    }

    public final Instant usageStartTimestamp() {
        return this.usageStartTimestamp;
    }

    public final Instant usageStopTimestamp() {
        return this.usageStopTimestamp;
    }

    public final Instant deletePendingTimestamp() {
        return this.deletePendingTimestamp;
    }

    public final Instant deleteTimestamp() {
        return this.deleteTimestamp;
    }

    public final DeriveKeyUsage deriveKeyUsage() {
        return DeriveKeyUsage.fromValue(this.deriveKeyUsage);
    }

    public final String deriveKeyUsageAsString() {
        return this.deriveKeyUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCheckValueAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportable());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageStopTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletePendingTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deriveKeyUsageAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        Key other = (Key)obj;
        return Objects.equals(this.keyArn(), other.keyArn()) && Objects.equals(this.keyAttributes(), other.keyAttributes()) && Objects.equals(this.keyCheckValue(), other.keyCheckValue()) && Objects.equals(this.keyCheckValueAlgorithmAsString(), other.keyCheckValueAlgorithmAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.exportable(), other.exportable()) && Objects.equals(this.keyStateAsString(), other.keyStateAsString()) && Objects.equals(this.keyOriginAsString(), other.keyOriginAsString()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.usageStartTimestamp(), other.usageStartTimestamp()) && Objects.equals(this.usageStopTimestamp(), other.usageStopTimestamp()) && Objects.equals(this.deletePendingTimestamp(), other.deletePendingTimestamp()) && Objects.equals(this.deleteTimestamp(), other.deleteTimestamp()) && Objects.equals(this.deriveKeyUsageAsString(), other.deriveKeyUsageAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Key").add("KeyArn", (Object)this.keyArn()).add("KeyAttributes", (Object)this.keyAttributes()).add("KeyCheckValue", (Object)this.keyCheckValue()).add("KeyCheckValueAlgorithm", (Object)this.keyCheckValueAlgorithmAsString()).add("Enabled", (Object)this.enabled()).add("Exportable", (Object)this.exportable()).add("KeyState", (Object)this.keyStateAsString()).add("KeyOrigin", (Object)this.keyOriginAsString()).add("CreateTimestamp", (Object)this.createTimestamp()).add("UsageStartTimestamp", (Object)this.usageStartTimestamp()).add("UsageStopTimestamp", (Object)this.usageStopTimestamp()).add("DeletePendingTimestamp", (Object)this.deletePendingTimestamp()).add("DeleteTimestamp", (Object)this.deleteTimestamp()).add("DeriveKeyUsage", (Object)this.deriveKeyUsageAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyArn": {
                return Optional.ofNullable(clazz.cast(this.keyArn()));
            }
            case "KeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.keyAttributes()));
            }
            case "KeyCheckValue": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValue()));
            }
            case "KeyCheckValueAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyCheckValueAlgorithmAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Exportable": {
                return Optional.ofNullable(clazz.cast(this.exportable()));
            }
            case "KeyState": {
                return Optional.ofNullable(clazz.cast(this.keyStateAsString()));
            }
            case "KeyOrigin": {
                return Optional.ofNullable(clazz.cast(this.keyOriginAsString()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "UsageStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.usageStartTimestamp()));
            }
            case "UsageStopTimestamp": {
                return Optional.ofNullable(clazz.cast(this.usageStopTimestamp()));
            }
            case "DeletePendingTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deletePendingTimestamp()));
            }
            case "DeleteTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deleteTimestamp()));
            }
            case "DeriveKeyUsage": {
                return Optional.ofNullable(clazz.cast(this.deriveKeyUsageAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyArn", KEY_ARN_FIELD);
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("KeyCheckValue", KEY_CHECK_VALUE_FIELD);
        map.put("KeyCheckValueAlgorithm", KEY_CHECK_VALUE_ALGORITHM_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("Exportable", EXPORTABLE_FIELD);
        map.put("KeyState", KEY_STATE_FIELD);
        map.put("KeyOrigin", KEY_ORIGIN_FIELD);
        map.put("CreateTimestamp", CREATE_TIMESTAMP_FIELD);
        map.put("UsageStartTimestamp", USAGE_START_TIMESTAMP_FIELD);
        map.put("UsageStopTimestamp", USAGE_STOP_TIMESTAMP_FIELD);
        map.put("DeletePendingTimestamp", DELETE_PENDING_TIMESTAMP_FIELD);
        map.put("DeleteTimestamp", DELETE_TIMESTAMP_FIELD);
        map.put("DeriveKeyUsage", DERIVE_KEY_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Key, T> g) {
        return obj -> g.apply((Key)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyArn;
        private KeyAttributes keyAttributes;
        private String keyCheckValue;
        private String keyCheckValueAlgorithm;
        private Boolean enabled;
        private Boolean exportable;
        private String keyState;
        private String keyOrigin;
        private Instant createTimestamp;
        private Instant usageStartTimestamp;
        private Instant usageStopTimestamp;
        private Instant deletePendingTimestamp;
        private Instant deleteTimestamp;
        private String deriveKeyUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(Key model) {
            this.keyArn(model.keyArn);
            this.keyAttributes(model.keyAttributes);
            this.keyCheckValue(model.keyCheckValue);
            this.keyCheckValueAlgorithm(model.keyCheckValueAlgorithm);
            this.enabled(model.enabled);
            this.exportable(model.exportable);
            this.keyState(model.keyState);
            this.keyOrigin(model.keyOrigin);
            this.createTimestamp(model.createTimestamp);
            this.usageStartTimestamp(model.usageStartTimestamp);
            this.usageStopTimestamp(model.usageStopTimestamp);
            this.deletePendingTimestamp(model.deletePendingTimestamp);
            this.deleteTimestamp(model.deleteTimestamp);
            this.deriveKeyUsage(model.deriveKeyUsage);
        }

        public final String getKeyArn() {
            return this.keyArn;
        }

        public final void setKeyArn(String keyArn) {
            this.keyArn = keyArn;
        }

        @Override
        public final Builder keyArn(String keyArn) {
            this.keyArn = keyArn;
            return this;
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return this.keyAttributes != null ? this.keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getKeyCheckValue() {
            return this.keyCheckValue;
        }

        public final void setKeyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
        }

        @Override
        public final Builder keyCheckValue(String keyCheckValue) {
            this.keyCheckValue = keyCheckValue;
            return this;
        }

        public final String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        public final void setKeyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        @Override
        public final Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm(keyCheckValueAlgorithm == null ? null : keyCheckValueAlgorithm.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getExportable() {
            return this.exportable;
        }

        public final void setExportable(Boolean exportable) {
            this.exportable = exportable;
        }

        @Override
        public final Builder exportable(Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public final String getKeyState() {
            return this.keyState;
        }

        public final void setKeyState(String keyState) {
            this.keyState = keyState;
        }

        @Override
        public final Builder keyState(String keyState) {
            this.keyState = keyState;
            return this;
        }

        @Override
        public final Builder keyState(KeyState keyState) {
            this.keyState(keyState == null ? null : keyState.toString());
            return this;
        }

        public final String getKeyOrigin() {
            return this.keyOrigin;
        }

        public final void setKeyOrigin(String keyOrigin) {
            this.keyOrigin = keyOrigin;
        }

        @Override
        public final Builder keyOrigin(String keyOrigin) {
            this.keyOrigin = keyOrigin;
            return this;
        }

        @Override
        public final Builder keyOrigin(KeyOrigin keyOrigin) {
            this.keyOrigin(keyOrigin == null ? null : keyOrigin.toString());
            return this;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final Instant getUsageStartTimestamp() {
            return this.usageStartTimestamp;
        }

        public final void setUsageStartTimestamp(Instant usageStartTimestamp) {
            this.usageStartTimestamp = usageStartTimestamp;
        }

        @Override
        public final Builder usageStartTimestamp(Instant usageStartTimestamp) {
            this.usageStartTimestamp = usageStartTimestamp;
            return this;
        }

        public final Instant getUsageStopTimestamp() {
            return this.usageStopTimestamp;
        }

        public final void setUsageStopTimestamp(Instant usageStopTimestamp) {
            this.usageStopTimestamp = usageStopTimestamp;
        }

        @Override
        public final Builder usageStopTimestamp(Instant usageStopTimestamp) {
            this.usageStopTimestamp = usageStopTimestamp;
            return this;
        }

        public final Instant getDeletePendingTimestamp() {
            return this.deletePendingTimestamp;
        }

        public final void setDeletePendingTimestamp(Instant deletePendingTimestamp) {
            this.deletePendingTimestamp = deletePendingTimestamp;
        }

        @Override
        public final Builder deletePendingTimestamp(Instant deletePendingTimestamp) {
            this.deletePendingTimestamp = deletePendingTimestamp;
            return this;
        }

        public final Instant getDeleteTimestamp() {
            return this.deleteTimestamp;
        }

        public final void setDeleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
        }

        @Override
        public final Builder deleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
            return this;
        }

        public final String getDeriveKeyUsage() {
            return this.deriveKeyUsage;
        }

        public final void setDeriveKeyUsage(String deriveKeyUsage) {
            this.deriveKeyUsage = deriveKeyUsage;
        }

        @Override
        public final Builder deriveKeyUsage(String deriveKeyUsage) {
            this.deriveKeyUsage = deriveKeyUsage;
            return this;
        }

        @Override
        public final Builder deriveKeyUsage(DeriveKeyUsage deriveKeyUsage) {
            this.deriveKeyUsage(deriveKeyUsage == null ? null : deriveKeyUsage.toString());
            return this;
        }

        public Key build() {
            return new Key(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Key> {
        public Builder keyArn(String var1);

        public Builder keyAttributes(KeyAttributes var1);

        default public Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return this.keyAttributes((KeyAttributes)((KeyAttributes.Builder)KeyAttributes.builder().applyMutation(keyAttributes)).build());
        }

        public Builder keyCheckValue(String var1);

        public Builder keyCheckValueAlgorithm(String var1);

        public Builder keyCheckValueAlgorithm(KeyCheckValueAlgorithm var1);

        public Builder enabled(Boolean var1);

        public Builder exportable(Boolean var1);

        public Builder keyState(String var1);

        public Builder keyState(KeyState var1);

        public Builder keyOrigin(String var1);

        public Builder keyOrigin(KeyOrigin var1);

        public Builder createTimestamp(Instant var1);

        public Builder usageStartTimestamp(Instant var1);

        public Builder usageStopTimestamp(Instant var1);

        public Builder deletePendingTimestamp(Instant var1);

        public Builder deleteTimestamp(Instant var1);

        public Builder deriveKeyUsage(String var1);

        public Builder deriveKeyUsage(DeriveKeyUsage var1);
    }
}

