/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.paymentcryptography.model.ExportDiffieHellmanTr31KeyBlock;
import software.amazon.awssdk.services.paymentcryptography.model.ExportKeyCryptogram;
import software.amazon.awssdk.services.paymentcryptography.model.ExportTr31KeyBlock;
import software.amazon.awssdk.services.paymentcryptography.model.ExportTr34KeyBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportKeyMaterial
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportKeyMaterial> {
    private static final SdkField<ExportTr31KeyBlock> TR31_KEY_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tr31KeyBlock").getter(ExportKeyMaterial.getter(ExportKeyMaterial::tr31KeyBlock)).setter(ExportKeyMaterial.setter(Builder::tr31KeyBlock)).constructor(ExportTr31KeyBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr31KeyBlock").build()}).build();
    private static final SdkField<ExportTr34KeyBlock> TR34_KEY_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tr34KeyBlock").getter(ExportKeyMaterial.getter(ExportKeyMaterial::tr34KeyBlock)).setter(ExportKeyMaterial.setter(Builder::tr34KeyBlock)).constructor(ExportTr34KeyBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tr34KeyBlock").build()}).build();
    private static final SdkField<ExportKeyCryptogram> KEY_CRYPTOGRAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyCryptogram").getter(ExportKeyMaterial.getter(ExportKeyMaterial::keyCryptogram)).setter(ExportKeyMaterial.setter(Builder::keyCryptogram)).constructor(ExportKeyCryptogram::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyCryptogram").build()}).build();
    private static final SdkField<ExportDiffieHellmanTr31KeyBlock> DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiffieHellmanTr31KeyBlock").getter(ExportKeyMaterial.getter(ExportKeyMaterial::diffieHellmanTr31KeyBlock)).setter(ExportKeyMaterial.setter(Builder::diffieHellmanTr31KeyBlock)).constructor(ExportDiffieHellmanTr31KeyBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiffieHellmanTr31KeyBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TR31_KEY_BLOCK_FIELD, TR34_KEY_BLOCK_FIELD, KEY_CRYPTOGRAM_FIELD, DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportKeyMaterial.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ExportTr31KeyBlock tr31KeyBlock;
    private final ExportTr34KeyBlock tr34KeyBlock;
    private final ExportKeyCryptogram keyCryptogram;
    private final ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock;
    private final Type type;

    private ExportKeyMaterial(BuilderImpl builder) {
        this.tr31KeyBlock = builder.tr31KeyBlock;
        this.tr34KeyBlock = builder.tr34KeyBlock;
        this.keyCryptogram = builder.keyCryptogram;
        this.diffieHellmanTr31KeyBlock = builder.diffieHellmanTr31KeyBlock;
        this.type = builder.type;
    }

    public final ExportTr31KeyBlock tr31KeyBlock() {
        return this.tr31KeyBlock;
    }

    public final ExportTr34KeyBlock tr34KeyBlock() {
        return this.tr34KeyBlock;
    }

    public final ExportKeyCryptogram keyCryptogram() {
        return this.keyCryptogram;
    }

    public final ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock() {
        return this.diffieHellmanTr31KeyBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tr31KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.tr34KeyBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(this.diffieHellmanTr31KeyBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportKeyMaterial)) {
            return false;
        }
        ExportKeyMaterial other = (ExportKeyMaterial)obj;
        return Objects.equals(this.tr31KeyBlock(), other.tr31KeyBlock()) && Objects.equals(this.tr34KeyBlock(), other.tr34KeyBlock()) && Objects.equals(this.keyCryptogram(), other.keyCryptogram()) && Objects.equals(this.diffieHellmanTr31KeyBlock(), other.diffieHellmanTr31KeyBlock());
    }

    public final String toString() {
        return ToString.builder((String)"ExportKeyMaterial").add("Tr31KeyBlock", (Object)this.tr31KeyBlock()).add("Tr34KeyBlock", (Object)this.tr34KeyBlock()).add("KeyCryptogram", (Object)this.keyCryptogram()).add("DiffieHellmanTr31KeyBlock", (Object)this.diffieHellmanTr31KeyBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tr31KeyBlock": {
                return Optional.ofNullable(clazz.cast(this.tr31KeyBlock()));
            }
            case "Tr34KeyBlock": {
                return Optional.ofNullable(clazz.cast(this.tr34KeyBlock()));
            }
            case "KeyCryptogram": {
                return Optional.ofNullable(clazz.cast(this.keyCryptogram()));
            }
            case "DiffieHellmanTr31KeyBlock": {
                return Optional.ofNullable(clazz.cast(this.diffieHellmanTr31KeyBlock()));
            }
        }
        return Optional.empty();
    }

    public static ExportKeyMaterial fromTr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock) {
        return (ExportKeyMaterial)ExportKeyMaterial.builder().tr31KeyBlock(tr31KeyBlock).build();
    }

    public static ExportKeyMaterial fromTr31KeyBlock(Consumer<ExportTr31KeyBlock.Builder> tr31KeyBlock) {
        ExportTr31KeyBlock.Builder builder = ExportTr31KeyBlock.builder();
        tr31KeyBlock.accept(builder);
        return ExportKeyMaterial.fromTr31KeyBlock((ExportTr31KeyBlock)builder.build());
    }

    public static ExportKeyMaterial fromTr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock) {
        return (ExportKeyMaterial)ExportKeyMaterial.builder().tr34KeyBlock(tr34KeyBlock).build();
    }

    public static ExportKeyMaterial fromTr34KeyBlock(Consumer<ExportTr34KeyBlock.Builder> tr34KeyBlock) {
        ExportTr34KeyBlock.Builder builder = ExportTr34KeyBlock.builder();
        tr34KeyBlock.accept(builder);
        return ExportKeyMaterial.fromTr34KeyBlock((ExportTr34KeyBlock)builder.build());
    }

    public static ExportKeyMaterial fromKeyCryptogram(ExportKeyCryptogram keyCryptogram) {
        return (ExportKeyMaterial)ExportKeyMaterial.builder().keyCryptogram(keyCryptogram).build();
    }

    public static ExportKeyMaterial fromKeyCryptogram(Consumer<ExportKeyCryptogram.Builder> keyCryptogram) {
        ExportKeyCryptogram.Builder builder = ExportKeyCryptogram.builder();
        keyCryptogram.accept(builder);
        return ExportKeyMaterial.fromKeyCryptogram((ExportKeyCryptogram)builder.build());
    }

    public static ExportKeyMaterial fromDiffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock) {
        return (ExportKeyMaterial)ExportKeyMaterial.builder().diffieHellmanTr31KeyBlock(diffieHellmanTr31KeyBlock).build();
    }

    public static ExportKeyMaterial fromDiffieHellmanTr31KeyBlock(Consumer<ExportDiffieHellmanTr31KeyBlock.Builder> diffieHellmanTr31KeyBlock) {
        ExportDiffieHellmanTr31KeyBlock.Builder builder = ExportDiffieHellmanTr31KeyBlock.builder();
        diffieHellmanTr31KeyBlock.accept(builder);
        return ExportKeyMaterial.fromDiffieHellmanTr31KeyBlock((ExportDiffieHellmanTr31KeyBlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Tr31KeyBlock", TR31_KEY_BLOCK_FIELD);
        map.put("Tr34KeyBlock", TR34_KEY_BLOCK_FIELD);
        map.put("KeyCryptogram", KEY_CRYPTOGRAM_FIELD);
        map.put("DiffieHellmanTr31KeyBlock", DIFFIE_HELLMAN_TR31_KEY_BLOCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportKeyMaterial, T> g) {
        return obj -> g.apply((ExportKeyMaterial)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TR31_KEY_BLOCK,
        TR34_KEY_BLOCK,
        KEY_CRYPTOGRAM,
        DIFFIE_HELLMAN_TR31_KEY_BLOCK,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ExportTr31KeyBlock tr31KeyBlock;
        private ExportTr34KeyBlock tr34KeyBlock;
        private ExportKeyCryptogram keyCryptogram;
        private ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExportKeyMaterial model) {
            this.tr31KeyBlock(model.tr31KeyBlock);
            this.tr34KeyBlock(model.tr34KeyBlock);
            this.keyCryptogram(model.keyCryptogram);
            this.diffieHellmanTr31KeyBlock(model.diffieHellmanTr31KeyBlock);
        }

        public final ExportTr31KeyBlock.Builder getTr31KeyBlock() {
            return this.tr31KeyBlock != null ? this.tr31KeyBlock.toBuilder() : null;
        }

        public final void setTr31KeyBlock(ExportTr31KeyBlock.BuilderImpl tr31KeyBlock) {
            ExportTr31KeyBlock oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock != null ? tr31KeyBlock.build() : null;
            this.handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
        }

        @Override
        public final Builder tr31KeyBlock(ExportTr31KeyBlock tr31KeyBlock) {
            ExportTr31KeyBlock oldValue = this.tr31KeyBlock;
            this.tr31KeyBlock = tr31KeyBlock;
            this.handleUnionValueChange(Type.TR31_KEY_BLOCK, oldValue, this.tr31KeyBlock);
            return this;
        }

        public final ExportTr34KeyBlock.Builder getTr34KeyBlock() {
            return this.tr34KeyBlock != null ? this.tr34KeyBlock.toBuilder() : null;
        }

        public final void setTr34KeyBlock(ExportTr34KeyBlock.BuilderImpl tr34KeyBlock) {
            ExportTr34KeyBlock oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock != null ? tr34KeyBlock.build() : null;
            this.handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
        }

        @Override
        public final Builder tr34KeyBlock(ExportTr34KeyBlock tr34KeyBlock) {
            ExportTr34KeyBlock oldValue = this.tr34KeyBlock;
            this.tr34KeyBlock = tr34KeyBlock;
            this.handleUnionValueChange(Type.TR34_KEY_BLOCK, oldValue, this.tr34KeyBlock);
            return this;
        }

        public final ExportKeyCryptogram.Builder getKeyCryptogram() {
            return this.keyCryptogram != null ? this.keyCryptogram.toBuilder() : null;
        }

        public final void setKeyCryptogram(ExportKeyCryptogram.BuilderImpl keyCryptogram) {
            ExportKeyCryptogram oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram != null ? keyCryptogram.build() : null;
            this.handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
        }

        @Override
        public final Builder keyCryptogram(ExportKeyCryptogram keyCryptogram) {
            ExportKeyCryptogram oldValue = this.keyCryptogram;
            this.keyCryptogram = keyCryptogram;
            this.handleUnionValueChange(Type.KEY_CRYPTOGRAM, oldValue, this.keyCryptogram);
            return this;
        }

        public final ExportDiffieHellmanTr31KeyBlock.Builder getDiffieHellmanTr31KeyBlock() {
            return this.diffieHellmanTr31KeyBlock != null ? this.diffieHellmanTr31KeyBlock.toBuilder() : null;
        }

        public final void setDiffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock.BuilderImpl diffieHellmanTr31KeyBlock) {
            ExportDiffieHellmanTr31KeyBlock oldValue = this.diffieHellmanTr31KeyBlock;
            this.diffieHellmanTr31KeyBlock = diffieHellmanTr31KeyBlock != null ? diffieHellmanTr31KeyBlock.build() : null;
            this.handleUnionValueChange(Type.DIFFIE_HELLMAN_TR31_KEY_BLOCK, oldValue, this.diffieHellmanTr31KeyBlock);
        }

        @Override
        public final Builder diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock diffieHellmanTr31KeyBlock) {
            ExportDiffieHellmanTr31KeyBlock oldValue = this.diffieHellmanTr31KeyBlock;
            this.diffieHellmanTr31KeyBlock = diffieHellmanTr31KeyBlock;
            this.handleUnionValueChange(Type.DIFFIE_HELLMAN_TR31_KEY_BLOCK, oldValue, this.diffieHellmanTr31KeyBlock);
            return this;
        }

        public ExportKeyMaterial build() {
            return new ExportKeyMaterial(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportKeyMaterial> {
        public Builder tr31KeyBlock(ExportTr31KeyBlock var1);

        default public Builder tr31KeyBlock(Consumer<ExportTr31KeyBlock.Builder> tr31KeyBlock) {
            return this.tr31KeyBlock((ExportTr31KeyBlock)((ExportTr31KeyBlock.Builder)ExportTr31KeyBlock.builder().applyMutation(tr31KeyBlock)).build());
        }

        public Builder tr34KeyBlock(ExportTr34KeyBlock var1);

        default public Builder tr34KeyBlock(Consumer<ExportTr34KeyBlock.Builder> tr34KeyBlock) {
            return this.tr34KeyBlock((ExportTr34KeyBlock)((ExportTr34KeyBlock.Builder)ExportTr34KeyBlock.builder().applyMutation(tr34KeyBlock)).build());
        }

        public Builder keyCryptogram(ExportKeyCryptogram var1);

        default public Builder keyCryptogram(Consumer<ExportKeyCryptogram.Builder> keyCryptogram) {
            return this.keyCryptogram((ExportKeyCryptogram)((ExportKeyCryptogram.Builder)ExportKeyCryptogram.builder().applyMutation(keyCryptogram)).build());
        }

        public Builder diffieHellmanTr31KeyBlock(ExportDiffieHellmanTr31KeyBlock var1);

        default public Builder diffieHellmanTr31KeyBlock(Consumer<ExportDiffieHellmanTr31KeyBlock.Builder> diffieHellmanTr31KeyBlock) {
            return this.diffieHellmanTr31KeyBlock((ExportDiffieHellmanTr31KeyBlock)((ExportDiffieHellmanTr31KeyBlock.Builder)ExportDiffieHellmanTr31KeyBlock.builder().applyMutation(diffieHellmanTr31KeyBlock)).build());
        }
    }
}

