/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportTr34KeyBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportTr34KeyBlock> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateAuthorityPublicKeyIdentifier").getter(ImportTr34KeyBlock.getter(ImportTr34KeyBlock::certificateAuthorityPublicKeyIdentifier)).setter(ImportTr34KeyBlock.setter(Builder::certificateAuthorityPublicKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityPublicKeyIdentifier").build()}).build();
    private static final SdkField<String> IMPORT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportToken").getter(ImportTr34KeyBlock.getter(ImportTr34KeyBlock::importToken)).setter(ImportTr34KeyBlock.setter(Builder::importToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportToken").build()}).build();
    private static final SdkField<String> KEY_BLOCK_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyBlockFormat").getter(ImportTr34KeyBlock.getter(ImportTr34KeyBlock::keyBlockFormatAsString)).setter(ImportTr34KeyBlock.setter(Builder::keyBlockFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyBlockFormat").build()}).build();
    private static final SdkField<String> RANDOM_NONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RandomNonce").getter(ImportTr34KeyBlock.getter(ImportTr34KeyBlock::randomNonce)).setter(ImportTr34KeyBlock.setter(Builder::randomNonce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RandomNonce").build()}).build();
    private static final SdkField<String> SIGNING_KEY_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningKeyCertificate").getter(ImportTr34KeyBlock.getter(ImportTr34KeyBlock::signingKeyCertificate)).setter(ImportTr34KeyBlock.setter(Builder::signingKeyCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningKeyCertificate").build()}).build();
    private static final SdkField<String> WRAPPED_KEY_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappedKeyBlock").getter(ImportTr34KeyBlock.getter(ImportTr34KeyBlock::wrappedKeyBlock)).setter(ImportTr34KeyBlock.setter(Builder::wrappedKeyBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappedKeyBlock").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_PUBLIC_KEY_IDENTIFIER_FIELD, IMPORT_TOKEN_FIELD, KEY_BLOCK_FORMAT_FIELD, RANDOM_NONCE_FIELD, SIGNING_KEY_CERTIFICATE_FIELD, WRAPPED_KEY_BLOCK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateAuthorityPublicKeyIdentifier;
    private final String importToken;
    private final String keyBlockFormat;
    private final String randomNonce;
    private final String signingKeyCertificate;
    private final String wrappedKeyBlock;

    private ImportTr34KeyBlock(BuilderImpl builder) {
        this.certificateAuthorityPublicKeyIdentifier = builder.certificateAuthorityPublicKeyIdentifier;
        this.importToken = builder.importToken;
        this.keyBlockFormat = builder.keyBlockFormat;
        this.randomNonce = builder.randomNonce;
        this.signingKeyCertificate = builder.signingKeyCertificate;
        this.wrappedKeyBlock = builder.wrappedKeyBlock;
    }

    public final String certificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public final String importToken() {
        return this.importToken;
    }

    public final Tr34KeyBlockFormat keyBlockFormat() {
        return Tr34KeyBlockFormat.fromValue(this.keyBlockFormat);
    }

    public final String keyBlockFormatAsString() {
        return this.keyBlockFormat;
    }

    public final String randomNonce() {
        return this.randomNonce;
    }

    public final String signingKeyCertificate() {
        return this.signingKeyCertificate;
    }

    public final String wrappedKeyBlock() {
        return this.wrappedKeyBlock;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityPublicKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.importToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyBlockFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.randomNonce());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingKeyCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappedKeyBlock());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTr34KeyBlock)) {
            return false;
        }
        ImportTr34KeyBlock other = (ImportTr34KeyBlock)obj;
        return Objects.equals(this.certificateAuthorityPublicKeyIdentifier(), other.certificateAuthorityPublicKeyIdentifier()) && Objects.equals(this.importToken(), other.importToken()) && Objects.equals(this.keyBlockFormatAsString(), other.keyBlockFormatAsString()) && Objects.equals(this.randomNonce(), other.randomNonce()) && Objects.equals(this.signingKeyCertificate(), other.signingKeyCertificate()) && Objects.equals(this.wrappedKeyBlock(), other.wrappedKeyBlock());
    }

    public final String toString() {
        return ToString.builder((String)"ImportTr34KeyBlock").add("CertificateAuthorityPublicKeyIdentifier", (Object)this.certificateAuthorityPublicKeyIdentifier()).add("ImportToken", (Object)this.importToken()).add("KeyBlockFormat", (Object)this.keyBlockFormatAsString()).add("RandomNonce", (Object)this.randomNonce()).add("SigningKeyCertificate", (Object)(this.signingKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***")).add("WrappedKeyBlock", (Object)this.wrappedKeyBlock()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityPublicKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityPublicKeyIdentifier()));
            }
            case "ImportToken": {
                return Optional.ofNullable(clazz.cast(this.importToken()));
            }
            case "KeyBlockFormat": {
                return Optional.ofNullable(clazz.cast(this.keyBlockFormatAsString()));
            }
            case "RandomNonce": {
                return Optional.ofNullable(clazz.cast(this.randomNonce()));
            }
            case "SigningKeyCertificate": {
                return Optional.ofNullable(clazz.cast(this.signingKeyCertificate()));
            }
            case "WrappedKeyBlock": {
                return Optional.ofNullable(clazz.cast(this.wrappedKeyBlock()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTr34KeyBlock, T> g) {
        return obj -> g.apply((ImportTr34KeyBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateAuthorityPublicKeyIdentifier;
        private String importToken;
        private String keyBlockFormat;
        private String randomNonce;
        private String signingKeyCertificate;
        private String wrappedKeyBlock;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTr34KeyBlock model) {
            this.certificateAuthorityPublicKeyIdentifier(model.certificateAuthorityPublicKeyIdentifier);
            this.importToken(model.importToken);
            this.keyBlockFormat(model.keyBlockFormat);
            this.randomNonce(model.randomNonce);
            this.signingKeyCertificate(model.signingKeyCertificate);
            this.wrappedKeyBlock(model.wrappedKeyBlock);
        }

        public final String getCertificateAuthorityPublicKeyIdentifier() {
            return this.certificateAuthorityPublicKeyIdentifier;
        }

        public final void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
        }

        @Override
        public final Builder certificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
            this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
            return this;
        }

        public final String getImportToken() {
            return this.importToken;
        }

        public final void setImportToken(String importToken) {
            this.importToken = importToken;
        }

        @Override
        public final Builder importToken(String importToken) {
            this.importToken = importToken;
            return this;
        }

        public final String getKeyBlockFormat() {
            return this.keyBlockFormat;
        }

        public final void setKeyBlockFormat(String keyBlockFormat) {
            this.keyBlockFormat = keyBlockFormat;
        }

        @Override
        public final Builder keyBlockFormat(String keyBlockFormat) {
            this.keyBlockFormat = keyBlockFormat;
            return this;
        }

        @Override
        public final Builder keyBlockFormat(Tr34KeyBlockFormat keyBlockFormat) {
            this.keyBlockFormat(keyBlockFormat == null ? null : keyBlockFormat.toString());
            return this;
        }

        public final String getRandomNonce() {
            return this.randomNonce;
        }

        public final void setRandomNonce(String randomNonce) {
            this.randomNonce = randomNonce;
        }

        @Override
        public final Builder randomNonce(String randomNonce) {
            this.randomNonce = randomNonce;
            return this;
        }

        public final String getSigningKeyCertificate() {
            return this.signingKeyCertificate;
        }

        public final void setSigningKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
        }

        @Override
        public final Builder signingKeyCertificate(String signingKeyCertificate) {
            this.signingKeyCertificate = signingKeyCertificate;
            return this;
        }

        public final String getWrappedKeyBlock() {
            return this.wrappedKeyBlock;
        }

        public final void setWrappedKeyBlock(String wrappedKeyBlock) {
            this.wrappedKeyBlock = wrappedKeyBlock;
        }

        @Override
        public final Builder wrappedKeyBlock(String wrappedKeyBlock) {
            this.wrappedKeyBlock = wrappedKeyBlock;
            return this;
        }

        public ImportTr34KeyBlock build() {
            return new ImportTr34KeyBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportTr34KeyBlock> {
        public Builder certificateAuthorityPublicKeyIdentifier(String var1);

        public Builder importToken(String var1);

        public Builder keyBlockFormat(String var1);

        public Builder keyBlockFormat(Tr34KeyBlockFormat var1);

        public Builder randomNonce(String var1);

        public Builder signingKeyCertificate(String var1);

        public Builder wrappedKeyBlock(String var1);
    }
}

