/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKeysResponse extends PaymentCryptographyResponse implements
        ToCopyableBuilder<ListKeysResponse.Builder, ListKeysResponse> {
    private static final SdkField<List<KeySummary>> KEYS_FIELD = SdkField
            .<List<KeySummary>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(ListKeysResponse::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KeySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(KeySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYS_FIELD, NEXT_TOKEN_FIELD));

    private final List<KeySummary> keys;

    private final String nextToken;

    private ListKeysResponse(BuilderImpl builder) {
        super(builder);
        this.keys = builder.keys;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of keys created within the caller's Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return The list of keys created within the caller's Amazon Web Services account and Amazon Web Services Region.
     */
    public final List<KeySummary> keys() {
        return keys;
    }

    /**
     * <p>
     * The token for the next set of results, or an empty or null value if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or an empty or null value if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeysResponse)) {
            return false;
        }
        ListKeysResponse other = (ListKeysResponse) obj;
        return hasKeys() == other.hasKeys() && Objects.equals(keys(), other.keys())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKeysResponse").add("Keys", hasKeys() ? keys() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListKeysResponse, T> g) {
        return obj -> g.apply((ListKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKeysResponse> {
        /**
         * <p>
         * The list of keys created within the caller's Amazon Web Services account and Amazon Web Services Region.
         * </p>
         * 
         * @param keys
         *        The list of keys created within the caller's Amazon Web Services account and Amazon Web Services
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<KeySummary> keys);

        /**
         * <p>
         * The list of keys created within the caller's Amazon Web Services account and Amazon Web Services Region.
         * </p>
         * 
         * @param keys
         *        The list of keys created within the caller's Amazon Web Services account and Amazon Web Services
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(KeySummary... keys);

        /**
         * <p>
         * The list of keys created within the caller's Amazon Web Services account and Amazon Web Services Region.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.paymentcryptography.model.KeySummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.paymentcryptography.model.KeySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.paymentcryptography.model.KeySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #keys(List<KeySummary>)}.
         * 
         * @param keys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.paymentcryptography.model.KeySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keys(java.util.Collection<KeySummary>)
         */
        Builder keys(Consumer<KeySummary.Builder>... keys);

        /**
         * <p>
         * The token for the next set of results, or an empty or null value if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or an empty or null value if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PaymentCryptographyResponse.BuilderImpl implements Builder {
        private List<KeySummary> keys = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeysResponse model) {
            super(model);
            keys(model.keys);
            nextToken(model.nextToken);
        }

        public final List<KeySummary.Builder> getKeys() {
            List<KeySummary.Builder> result = KeySummaryListCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeys(Collection<KeySummary.BuilderImpl> keys) {
            this.keys = KeySummaryListCopier.copyFromBuilder(keys);
        }

        @Override
        public final Builder keys(Collection<KeySummary> keys) {
            this.keys = KeySummaryListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(KeySummary... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Consumer<KeySummary.Builder>... keys) {
            keys(Stream.of(keys).map(c -> KeySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListKeysResponse build() {
            return new ListKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
