/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.paymentcryptography.DefaultPaymentCryptographyAsyncClient;
import software.amazon.awssdk.services.paymentcryptography.DefaultPaymentCryptographyBaseClientBuilder;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyAsyncClient;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyAsyncClientBuilder;
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyServiceClientConfiguration;
import software.amazon.awssdk.services.paymentcryptography.endpoints.PaymentCryptographyEndpointProvider;

@SdkInternalApi
final class DefaultPaymentCryptographyAsyncClientBuilder
extends DefaultPaymentCryptographyBaseClientBuilder<PaymentCryptographyAsyncClientBuilder, PaymentCryptographyAsyncClient>
implements PaymentCryptographyAsyncClientBuilder {
    DefaultPaymentCryptographyAsyncClientBuilder() {
    }

    @Override
    public DefaultPaymentCryptographyAsyncClientBuilder endpointProvider(PaymentCryptographyEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final PaymentCryptographyAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultPaymentCryptographyAsyncClientBuilder.validateClientOptions(clientConfiguration);
        PaymentCryptographyServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultPaymentCryptographyAsyncClient client = new DefaultPaymentCryptographyAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private PaymentCryptographyServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return PaymentCryptographyServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

