/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.services.panorama.model.StorageLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackageResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, CreatePackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreatePackageResponse.getter(CreatePackageResponse::arn)).setter(CreatePackageResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageId").getter(CreatePackageResponse.getter(CreatePackageResponse::packageId)).setter(CreatePackageResponse.setter(Builder::packageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()}).build();
    private static final SdkField<StorageLocation> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageLocation").getter(CreatePackageResponse.getter(CreatePackageResponse::storageLocation)).setter(CreatePackageResponse.setter(Builder::storageLocation)).constructor(StorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PACKAGE_ID_FIELD, STORAGE_LOCATION_FIELD));
    private final String arn;
    private final String packageId;
    private final StorageLocation storageLocation;

    private CreatePackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.packageId = builder.packageId;
        this.storageLocation = builder.storageLocation;
    }

    public final String arn() {
        return this.arn;
    }

    public final String packageId() {
        return this.packageId;
    }

    public final StorageLocation storageLocation() {
        return this.storageLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageResponse)) {
            return false;
        }
        CreatePackageResponse other = (CreatePackageResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.packageId(), other.packageId()) && Objects.equals(this.storageLocation(), other.storageLocation());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePackageResponse").add("Arn", (Object)this.arn()).add("PackageId", (Object)this.packageId()).add("StorageLocation", (Object)this.storageLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "PackageId": {
                return Optional.ofNullable(clazz.cast(this.packageId()));
            }
            case "StorageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageResponse, T> g) {
        return obj -> g.apply((CreatePackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String packageId;
        private StorageLocation storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageResponse model) {
            super(model);
            this.arn(model.arn);
            this.packageId(model.packageId);
            this.storageLocation(model.storageLocation);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPackageId() {
            return this.packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final StorageLocation.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(StorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(StorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        @Override
        public CreatePackageResponse build() {
            return new CreatePackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackageResponse> {
        public Builder arn(String var1);

        public Builder packageId(String var1);

        public Builder storageLocation(StorageLocation var1);

        default public Builder storageLocation(Consumer<StorageLocation.Builder> storageLocation) {
            return this.storageLocation((StorageLocation)((StorageLocation.Builder)StorageLocation.builder().applyMutation(storageLocation)).build());
        }
    }
}

