/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.panorama.PanoramaClient;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsRequest;
import software.amazon.awssdk.services.panorama.model.ListPackageImportJobsResponse;

public class ListPackageImportJobsIterable
implements SdkIterable<ListPackageImportJobsResponse> {
    private final PanoramaClient client;
    private final ListPackageImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackageImportJobsIterable(PanoramaClient client, ListPackageImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPackageImportJobsResponseFetcher();
    }

    public Iterator<ListPackageImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPackageImportJobsResponseFetcher
    implements SyncPageFetcher<ListPackageImportJobsResponse> {
        private ListPackageImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackageImportJobsResponse nextPage(ListPackageImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageImportJobsIterable.this.client.listPackageImportJobs(ListPackageImportJobsIterable.this.firstRequest);
            }
            return ListPackageImportJobsIterable.this.client.listPackageImportJobs((ListPackageImportJobsRequest)((Object)ListPackageImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

