/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.Address;
import software.amazon.awssdk.services.outposts.model.AddressType;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSiteAddressResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, UpdateSiteAddressResponse> {
    private static final SdkField<String> ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressType").getter(UpdateSiteAddressResponse.getter(UpdateSiteAddressResponse::addressTypeAsString)).setter(UpdateSiteAddressResponse.setter(Builder::addressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressType").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(UpdateSiteAddressResponse.getter(UpdateSiteAddressResponse::address)).setter(UpdateSiteAddressResponse.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_TYPE_FIELD, ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSiteAddressResponse.memberNameToFieldInitializer();
    private final String addressType;
    private final Address address;

    private UpdateSiteAddressResponse(BuilderImpl builder) {
        super(builder);
        this.addressType = builder.addressType;
        this.address = builder.address;
    }

    public final AddressType addressType() {
        return AddressType.fromValue(this.addressType);
    }

    public final String addressTypeAsString() {
        return this.addressType;
    }

    public final Address address() {
        return this.address;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.addressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSiteAddressResponse)) {
            return false;
        }
        UpdateSiteAddressResponse other = (UpdateSiteAddressResponse)((Object)obj);
        return Objects.equals(this.addressTypeAsString(), other.addressTypeAsString()) && Objects.equals(this.address(), other.address());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSiteAddressResponse").add("AddressType", (Object)this.addressTypeAsString()).add("Address", (Object)this.address()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddressType": {
                return Optional.ofNullable(clazz.cast(this.addressTypeAsString()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddressType", ADDRESS_TYPE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSiteAddressResponse, T> g) {
        return obj -> g.apply((UpdateSiteAddressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private String addressType;
        private Address address;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSiteAddressResponse model) {
            super(model);
            this.addressType(model.addressType);
            this.address(model.address);
        }

        public final String getAddressType() {
            return this.addressType;
        }

        public final void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        @Override
        public final Builder addressType(String addressType) {
            this.addressType = addressType;
            return this;
        }

        @Override
        public final Builder addressType(AddressType addressType) {
            this.addressType(addressType == null ? null : addressType.toString());
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        @Override
        public UpdateSiteAddressResponse build() {
            return new UpdateSiteAddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSiteAddressResponse> {
        public Builder addressType(String var1);

        public Builder addressType(AddressType var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }
    }
}

