/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.OrderSummary;
import software.amazon.awssdk.services.outposts.model.OrderSummaryListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrdersResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, ListOrdersResponse> {
    private static final SdkField<List<OrderSummary>> ORDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Orders").getter(ListOrdersResponse.getter(ListOrdersResponse::orders)).setter(ListOrdersResponse.setter(Builder::orders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrdersResponse.getter(ListOrdersResponse::nextToken)).setter(ListOrdersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOrdersResponse.memberNameToFieldInitializer();
    private final List<OrderSummary> orders;
    private final String nextToken;

    private ListOrdersResponse(BuilderImpl builder) {
        super(builder);
        this.orders = builder.orders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrders() {
        return this.orders != null && !(this.orders instanceof SdkAutoConstructList);
    }

    public final List<OrderSummary> orders() {
        return this.orders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrders() ? this.orders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrdersResponse)) {
            return false;
        }
        ListOrdersResponse other = (ListOrdersResponse)((Object)obj);
        return this.hasOrders() == other.hasOrders() && Objects.equals(this.orders(), other.orders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrdersResponse").add("Orders", this.hasOrders() ? this.orders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Orders": {
                return Optional.ofNullable(clazz.cast(this.orders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Orders", ORDERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOrdersResponse, T> g) {
        return obj -> g.apply((ListOrdersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<OrderSummary> orders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrdersResponse model) {
            super(model);
            this.orders(model.orders);
            this.nextToken(model.nextToken);
        }

        public final List<OrderSummary.Builder> getOrders() {
            List<OrderSummary.Builder> result = OrderSummaryListDefinitionCopier.copyToBuilder(this.orders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrders(Collection<OrderSummary.BuilderImpl> orders) {
            this.orders = OrderSummaryListDefinitionCopier.copyFromBuilder(orders);
        }

        @Override
        public final Builder orders(Collection<OrderSummary> orders) {
            this.orders = OrderSummaryListDefinitionCopier.copy(orders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orders(OrderSummary ... orders) {
            this.orders(Arrays.asList(orders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orders(Consumer<OrderSummary.Builder> ... orders) {
            this.orders(Stream.of(orders).map(c -> (OrderSummary)((OrderSummary.Builder)OrderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOrdersResponse build() {
            return new ListOrdersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrdersResponse> {
        public Builder orders(Collection<OrderSummary> var1);

        public Builder orders(OrderSummary ... var1);

        public Builder orders(Consumer<OrderSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

