/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CatalogItemStatus;
import software.amazon.awssdk.services.outposts.model.EC2Capacity;
import software.amazon.awssdk.services.outposts.model.EC2CapacityListDefinitionCopier;
import software.amazon.awssdk.services.outposts.model.SupportedStorageEnum;
import software.amazon.awssdk.services.outposts.model.SupportedStorageListCopier;
import software.amazon.awssdk.services.outposts.model.SupportedUplinkGbpsListDefinitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogItem> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogItemId").getter(CatalogItem.getter(CatalogItem::catalogItemId)).setter(CatalogItem.setter(Builder::catalogItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()}).build();
    private static final SdkField<String> ITEM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ItemStatus").getter(CatalogItem.getter(CatalogItem::itemStatusAsString)).setter(CatalogItem.setter(Builder::itemStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemStatus").build()}).build();
    private static final SdkField<List<EC2Capacity>> EC2_CAPACITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2Capacities").getter(CatalogItem.getter(CatalogItem::ec2Capacities)).setter(CatalogItem.setter(Builder::ec2Capacities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2Capacities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Float> POWER_KVA_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("PowerKva").getter(CatalogItem.getter(CatalogItem::powerKva)).setter(CatalogItem.setter(Builder::powerKva)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerKva").build()}).build();
    private static final SdkField<Integer> WEIGHT_LBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WeightLbs").getter(CatalogItem.getter(CatalogItem::weightLbs)).setter(CatalogItem.setter(Builder::weightLbs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightLbs").build()}).build();
    private static final SdkField<List<Integer>> SUPPORTED_UPLINK_GBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedUplinkGbps").getter(CatalogItem.getter(CatalogItem::supportedUplinkGbps)).setter(CatalogItem.setter(Builder::supportedUplinkGbps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedUplinkGbps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedStorage").getter(CatalogItem.getter(CatalogItem::supportedStorageAsStrings)).setter(CatalogItem.setter(Builder::supportedStorageWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedStorage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD, ITEM_STATUS_FIELD, EC2_CAPACITIES_FIELD, POWER_KVA_FIELD, WEIGHT_LBS_FIELD, SUPPORTED_UPLINK_GBPS_FIELD, SUPPORTED_STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CatalogItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String catalogItemId;
    private final String itemStatus;
    private final List<EC2Capacity> ec2Capacities;
    private final Float powerKva;
    private final Integer weightLbs;
    private final List<Integer> supportedUplinkGbps;
    private final List<String> supportedStorage;

    private CatalogItem(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.itemStatus = builder.itemStatus;
        this.ec2Capacities = builder.ec2Capacities;
        this.powerKva = builder.powerKva;
        this.weightLbs = builder.weightLbs;
        this.supportedUplinkGbps = builder.supportedUplinkGbps;
        this.supportedStorage = builder.supportedStorage;
    }

    public final String catalogItemId() {
        return this.catalogItemId;
    }

    public final CatalogItemStatus itemStatus() {
        return CatalogItemStatus.fromValue(this.itemStatus);
    }

    public final String itemStatusAsString() {
        return this.itemStatus;
    }

    public final boolean hasEc2Capacities() {
        return this.ec2Capacities != null && !(this.ec2Capacities instanceof SdkAutoConstructList);
    }

    public final List<EC2Capacity> ec2Capacities() {
        return this.ec2Capacities;
    }

    public final Float powerKva() {
        return this.powerKva;
    }

    public final Integer weightLbs() {
        return this.weightLbs;
    }

    public final boolean hasSupportedUplinkGbps() {
        return this.supportedUplinkGbps != null && !(this.supportedUplinkGbps instanceof SdkAutoConstructList);
    }

    public final List<Integer> supportedUplinkGbps() {
        return this.supportedUplinkGbps;
    }

    public final List<SupportedStorageEnum> supportedStorage() {
        return SupportedStorageListCopier.copyStringToEnum(this.supportedStorage);
    }

    public final boolean hasSupportedStorage() {
        return this.supportedStorage != null && !(this.supportedStorage instanceof SdkAutoConstructList);
    }

    public final List<String> supportedStorageAsStrings() {
        return this.supportedStorage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2Capacities() ? this.ec2Capacities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.powerKva());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightLbs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedUplinkGbps() ? this.supportedUplinkGbps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedStorage() ? this.supportedStorageAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogItem)) {
            return false;
        }
        CatalogItem other = (CatalogItem)obj;
        return Objects.equals(this.catalogItemId(), other.catalogItemId()) && Objects.equals(this.itemStatusAsString(), other.itemStatusAsString()) && this.hasEc2Capacities() == other.hasEc2Capacities() && Objects.equals(this.ec2Capacities(), other.ec2Capacities()) && Objects.equals(this.powerKva(), other.powerKva()) && Objects.equals(this.weightLbs(), other.weightLbs()) && this.hasSupportedUplinkGbps() == other.hasSupportedUplinkGbps() && Objects.equals(this.supportedUplinkGbps(), other.supportedUplinkGbps()) && this.hasSupportedStorage() == other.hasSupportedStorage() && Objects.equals(this.supportedStorageAsStrings(), other.supportedStorageAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogItem").add("CatalogItemId", (Object)this.catalogItemId()).add("ItemStatus", (Object)this.itemStatusAsString()).add("EC2Capacities", this.hasEc2Capacities() ? this.ec2Capacities() : null).add("PowerKva", (Object)this.powerKva()).add("WeightLbs", (Object)this.weightLbs()).add("SupportedUplinkGbps", this.hasSupportedUplinkGbps() ? this.supportedUplinkGbps() : null).add("SupportedStorage", this.hasSupportedStorage() ? this.supportedStorageAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogItemId": {
                return Optional.ofNullable(clazz.cast(this.catalogItemId()));
            }
            case "ItemStatus": {
                return Optional.ofNullable(clazz.cast(this.itemStatusAsString()));
            }
            case "EC2Capacities": {
                return Optional.ofNullable(clazz.cast(this.ec2Capacities()));
            }
            case "PowerKva": {
                return Optional.ofNullable(clazz.cast(this.powerKva()));
            }
            case "WeightLbs": {
                return Optional.ofNullable(clazz.cast(this.weightLbs()));
            }
            case "SupportedUplinkGbps": {
                return Optional.ofNullable(clazz.cast(this.supportedUplinkGbps()));
            }
            case "SupportedStorage": {
                return Optional.ofNullable(clazz.cast(this.supportedStorageAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogItemId", CATALOG_ITEM_ID_FIELD);
        map.put("ItemStatus", ITEM_STATUS_FIELD);
        map.put("EC2Capacities", EC2_CAPACITIES_FIELD);
        map.put("PowerKva", POWER_KVA_FIELD);
        map.put("WeightLbs", WEIGHT_LBS_FIELD);
        map.put("SupportedUplinkGbps", SUPPORTED_UPLINK_GBPS_FIELD);
        map.put("SupportedStorage", SUPPORTED_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogItem, T> g) {
        return obj -> g.apply((CatalogItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String catalogItemId;
        private String itemStatus;
        private List<EC2Capacity> ec2Capacities = DefaultSdkAutoConstructList.getInstance();
        private Float powerKva;
        private Integer weightLbs;
        private List<Integer> supportedUplinkGbps = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedStorage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogItem model) {
            this.catalogItemId(model.catalogItemId);
            this.itemStatus(model.itemStatus);
            this.ec2Capacities(model.ec2Capacities);
            this.powerKva(model.powerKva);
            this.weightLbs(model.weightLbs);
            this.supportedUplinkGbps(model.supportedUplinkGbps);
            this.supportedStorageWithStrings(model.supportedStorage);
        }

        public final String getCatalogItemId() {
            return this.catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final String getItemStatus() {
            return this.itemStatus;
        }

        public final void setItemStatus(String itemStatus) {
            this.itemStatus = itemStatus;
        }

        @Override
        public final Builder itemStatus(String itemStatus) {
            this.itemStatus = itemStatus;
            return this;
        }

        @Override
        public final Builder itemStatus(CatalogItemStatus itemStatus) {
            this.itemStatus(itemStatus == null ? null : itemStatus.toString());
            return this;
        }

        public final List<EC2Capacity.Builder> getEc2Capacities() {
            List<EC2Capacity.Builder> result = EC2CapacityListDefinitionCopier.copyToBuilder(this.ec2Capacities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2Capacities(Collection<EC2Capacity.BuilderImpl> ec2Capacities) {
            this.ec2Capacities = EC2CapacityListDefinitionCopier.copyFromBuilder(ec2Capacities);
        }

        @Override
        public final Builder ec2Capacities(Collection<EC2Capacity> ec2Capacities) {
            this.ec2Capacities = EC2CapacityListDefinitionCopier.copy(ec2Capacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Capacities(EC2Capacity ... ec2Capacities) {
            this.ec2Capacities(Arrays.asList(ec2Capacities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Capacities(Consumer<EC2Capacity.Builder> ... ec2Capacities) {
            this.ec2Capacities(Stream.of(ec2Capacities).map(c -> (EC2Capacity)((EC2Capacity.Builder)EC2Capacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Float getPowerKva() {
            return this.powerKva;
        }

        public final void setPowerKva(Float powerKva) {
            this.powerKva = powerKva;
        }

        @Override
        public final Builder powerKva(Float powerKva) {
            this.powerKva = powerKva;
            return this;
        }

        public final Integer getWeightLbs() {
            return this.weightLbs;
        }

        public final void setWeightLbs(Integer weightLbs) {
            this.weightLbs = weightLbs;
        }

        @Override
        public final Builder weightLbs(Integer weightLbs) {
            this.weightLbs = weightLbs;
            return this;
        }

        public final Collection<Integer> getSupportedUplinkGbps() {
            if (this.supportedUplinkGbps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedUplinkGbps;
        }

        public final void setSupportedUplinkGbps(Collection<Integer> supportedUplinkGbps) {
            this.supportedUplinkGbps = SupportedUplinkGbpsListDefinitionCopier.copy(supportedUplinkGbps);
        }

        @Override
        public final Builder supportedUplinkGbps(Collection<Integer> supportedUplinkGbps) {
            this.supportedUplinkGbps = SupportedUplinkGbpsListDefinitionCopier.copy(supportedUplinkGbps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedUplinkGbps(Integer ... supportedUplinkGbps) {
            this.supportedUplinkGbps(Arrays.asList(supportedUplinkGbps));
            return this;
        }

        public final Collection<String> getSupportedStorage() {
            if (this.supportedStorage instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedStorage;
        }

        public final void setSupportedStorage(Collection<String> supportedStorage) {
            this.supportedStorage = SupportedStorageListCopier.copy(supportedStorage);
        }

        @Override
        public final Builder supportedStorageWithStrings(Collection<String> supportedStorage) {
            this.supportedStorage = SupportedStorageListCopier.copy(supportedStorage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorageWithStrings(String ... supportedStorage) {
            this.supportedStorageWithStrings(Arrays.asList(supportedStorage));
            return this;
        }

        @Override
        public final Builder supportedStorage(Collection<SupportedStorageEnum> supportedStorage) {
            this.supportedStorage = SupportedStorageListCopier.copyEnumToString(supportedStorage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorage(SupportedStorageEnum ... supportedStorage) {
            this.supportedStorage(Arrays.asList(supportedStorage));
            return this;
        }

        public CatalogItem build() {
            return new CatalogItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogItem> {
        public Builder catalogItemId(String var1);

        public Builder itemStatus(String var1);

        public Builder itemStatus(CatalogItemStatus var1);

        public Builder ec2Capacities(Collection<EC2Capacity> var1);

        public Builder ec2Capacities(EC2Capacity ... var1);

        public Builder ec2Capacities(Consumer<EC2Capacity.Builder> ... var1);

        public Builder powerKva(Float var1);

        public Builder weightLbs(Integer var1);

        public Builder supportedUplinkGbps(Collection<Integer> var1);

        public Builder supportedUplinkGbps(Integer ... var1);

        public Builder supportedStorageWithStrings(Collection<String> var1);

        public Builder supportedStorageWithStrings(String ... var1);

        public Builder supportedStorage(Collection<SupportedStorageEnum> var1);

        public Builder supportedStorage(SupportedStorageEnum ... var1);
    }
}

