/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.InstanceTypeItem;

public class GetOutpostSupportedInstanceTypesPublisher
implements SdkPublisher<GetOutpostSupportedInstanceTypesResponse> {
    private final OutpostsAsyncClient client;
    private final GetOutpostSupportedInstanceTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOutpostSupportedInstanceTypesPublisher(OutpostsAsyncClient client, GetOutpostSupportedInstanceTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOutpostSupportedInstanceTypesPublisher(OutpostsAsyncClient client, GetOutpostSupportedInstanceTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOutpostSupportedInstanceTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOutpostSupportedInstanceTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InstanceTypeItem> instanceTypes() {
        Function<GetOutpostSupportedInstanceTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceTypes() != null) {
                return response.instanceTypes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOutpostSupportedInstanceTypesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetOutpostSupportedInstanceTypesResponseFetcher
    implements AsyncPageFetcher<GetOutpostSupportedInstanceTypesResponse> {
        private GetOutpostSupportedInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetOutpostSupportedInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOutpostSupportedInstanceTypesResponse> nextPage(GetOutpostSupportedInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return GetOutpostSupportedInstanceTypesPublisher.this.client.getOutpostSupportedInstanceTypes(GetOutpostSupportedInstanceTypesPublisher.this.firstRequest);
            }
            return GetOutpostSupportedInstanceTypesPublisher.this.client.getOutpostSupportedInstanceTypes((GetOutpostSupportedInstanceTypesRequest)((Object)GetOutpostSupportedInstanceTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

