/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBlockingInstancesForCapacityTaskRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListBlockingInstancesForCapacityTaskRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostIdentifier").getter(ListBlockingInstancesForCapacityTaskRequest.getter(ListBlockingInstancesForCapacityTaskRequest::outpostIdentifier)).setter(ListBlockingInstancesForCapacityTaskRequest.setter(Builder::outpostIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()}).build();
    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityTaskId").getter(ListBlockingInstancesForCapacityTaskRequest.getter(ListBlockingInstancesForCapacityTaskRequest::capacityTaskId)).setter(ListBlockingInstancesForCapacityTaskRequest.setter(Builder::capacityTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CapacityTaskId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListBlockingInstancesForCapacityTaskRequest.getter(ListBlockingInstancesForCapacityTaskRequest::maxResults)).setter(ListBlockingInstancesForCapacityTaskRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBlockingInstancesForCapacityTaskRequest.getter(ListBlockingInstancesForCapacityTaskRequest::nextToken)).setter(ListBlockingInstancesForCapacityTaskRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD, CAPACITY_TASK_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OutpostId", OUTPOST_IDENTIFIER_FIELD);
            this.put("CapacityTaskId", CAPACITY_TASK_ID_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String outpostIdentifier;
    private final String capacityTaskId;
    private final Integer maxResults;
    private final String nextToken;

    private ListBlockingInstancesForCapacityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.capacityTaskId = builder.capacityTaskId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String outpostIdentifier() {
        return this.outpostIdentifier;
    }

    public final String capacityTaskId() {
        return this.capacityTaskId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlockingInstancesForCapacityTaskRequest)) {
            return false;
        }
        ListBlockingInstancesForCapacityTaskRequest other = (ListBlockingInstancesForCapacityTaskRequest)((Object)obj);
        return Objects.equals(this.outpostIdentifier(), other.outpostIdentifier()) && Objects.equals(this.capacityTaskId(), other.capacityTaskId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBlockingInstancesForCapacityTaskRequest").add("OutpostIdentifier", (Object)this.outpostIdentifier()).add("CapacityTaskId", (Object)this.capacityTaskId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outpostIdentifier()));
            }
            case "CapacityTaskId": {
                return Optional.ofNullable(clazz.cast(this.capacityTaskId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBlockingInstancesForCapacityTaskRequest, T> g) {
        return obj -> g.apply((ListBlockingInstancesForCapacityTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostIdentifier;
        private String capacityTaskId;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlockingInstancesForCapacityTaskRequest model) {
            super(model);
            this.outpostIdentifier(model.outpostIdentifier);
            this.capacityTaskId(model.capacityTaskId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getOutpostIdentifier() {
            return this.outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final String getCapacityTaskId() {
            return this.capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBlockingInstancesForCapacityTaskRequest build() {
            return new ListBlockingInstancesForCapacityTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBlockingInstancesForCapacityTaskRequest> {
        public Builder outpostIdentifier(String var1);

        public Builder capacityTaskId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

