/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTypeItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTypeItem> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceTypeItem.getter(InstanceTypeItem::instanceType)).setter(InstanceTypeItem.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> VCP_US_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VCPUs").getter(InstanceTypeItem.getter(InstanceTypeItem::vcpUs)).setter(InstanceTypeItem.setter(Builder::vcpUs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCPUs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, VCP_US_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer vcpUs;

    private InstanceTypeItem(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.vcpUs = builder.vcpUs;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer vcpUs() {
        return this.vcpUs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.vcpUs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeItem)) {
            return false;
        }
        InstanceTypeItem other = (InstanceTypeItem)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.vcpUs(), other.vcpUs());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTypeItem").add("InstanceType", (Object)this.instanceType()).add("VCPUs", (Object)this.vcpUs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "VCPUs": {
                return Optional.ofNullable(clazz.cast(this.vcpUs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeItem, T> g) {
        return obj -> g.apply((InstanceTypeItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer vcpUs;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeItem model) {
            this.instanceType(model.instanceType);
            this.vcpUs(model.vcpUs);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getVcpUs() {
            return this.vcpUs;
        }

        public final void setVcpUs(Integer vcpUs) {
            this.vcpUs = vcpUs;
        }

        @Override
        public final Builder vcpUs(Integer vcpUs) {
            this.vcpUs = vcpUs;
            return this;
        }

        public InstanceTypeItem build() {
            return new InstanceTypeItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTypeItem> {
        public Builder instanceType(String var1);

        public Builder vcpUs(Integer var1);
    }
}

