/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.CapacityTaskSummary;
import software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest;
import software.amazon.awssdk.services.outposts.model.ListCapacityTasksResponse;

public class ListCapacityTasksIterable
implements SdkIterable<ListCapacityTasksResponse> {
    private final OutpostsClient client;
    private final ListCapacityTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCapacityTasksIterable(OutpostsClient client, ListCapacityTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCapacityTasksResponseFetcher();
    }

    public Iterator<ListCapacityTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapacityTaskSummary> capacityTasks() {
        Function<ListCapacityTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityTasks() != null) {
                return response.capacityTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCapacityTasksResponseFetcher
    implements SyncPageFetcher<ListCapacityTasksResponse> {
        private ListCapacityTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListCapacityTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCapacityTasksResponse nextPage(ListCapacityTasksResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityTasksIterable.this.client.listCapacityTasks(ListCapacityTasksIterable.this.firstRequest);
            }
            return ListCapacityTasksIterable.this.client.listCapacityTasks((ListCapacityTasksRequest)((Object)ListCapacityTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

