/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse;

public class GetOutpostInstanceTypesIterable
implements SdkIterable<GetOutpostInstanceTypesResponse> {
    private final OutpostsClient client;
    private final GetOutpostInstanceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetOutpostInstanceTypesIterable(OutpostsClient client, GetOutpostInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetOutpostInstanceTypesResponseFetcher();
    }

    public Iterator<GetOutpostInstanceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetOutpostInstanceTypesResponseFetcher
    implements SyncPageFetcher<GetOutpostInstanceTypesResponse> {
        private GetOutpostInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetOutpostInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetOutpostInstanceTypesResponse nextPage(GetOutpostInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return GetOutpostInstanceTypesIterable.this.client.getOutpostInstanceTypes(GetOutpostInstanceTypesIterable.this.firstRequest);
            }
            return GetOutpostInstanceTypesIterable.this.client.getOutpostInstanceTypes((GetOutpostInstanceTypesRequest)((Object)GetOutpostInstanceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

