/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.HostIdListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssetsRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListAssetsRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostIdentifier").getter(ListAssetsRequest.getter(ListAssetsRequest::outpostIdentifier)).setter(ListAssetsRequest.setter(Builder::outpostIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()}).build();
    private static final SdkField<List<String>> HOST_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostIdFilter").getter(ListAssetsRequest.getter(ListAssetsRequest::hostIdFilter)).setter(ListAssetsRequest.setter(Builder::hostIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("HostIdFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAssetsRequest.getter(ListAssetsRequest::maxResults)).setter(ListAssetsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssetsRequest.getter(ListAssetsRequest::nextToken)).setter(ListAssetsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD, HOST_ID_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String outpostIdentifier;
    private final List<String> hostIdFilter;
    private final Integer maxResults;
    private final String nextToken;

    private ListAssetsRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.hostIdFilter = builder.hostIdFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String outpostIdentifier() {
        return this.outpostIdentifier;
    }

    public final boolean hasHostIdFilter() {
        return this.hostIdFilter != null && !(this.hostIdFilter instanceof SdkAutoConstructList);
    }

    public final List<String> hostIdFilter() {
        return this.hostIdFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostIdFilter() ? this.hostIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetsRequest)) {
            return false;
        }
        ListAssetsRequest other = (ListAssetsRequest)((Object)obj);
        return Objects.equals(this.outpostIdentifier(), other.outpostIdentifier()) && this.hasHostIdFilter() == other.hasHostIdFilter() && Objects.equals(this.hostIdFilter(), other.hostIdFilter()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssetsRequest").add("OutpostIdentifier", (Object)this.outpostIdentifier()).add("HostIdFilter", this.hasHostIdFilter() ? this.hostIdFilter() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutpostIdentifier": {
                return Optional.ofNullable(clazz.cast(this.outpostIdentifier()));
            }
            case "HostIdFilter": {
                return Optional.ofNullable(clazz.cast(this.hostIdFilter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssetsRequest, T> g) {
        return obj -> g.apply((ListAssetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String outpostIdentifier;
        private List<String> hostIdFilter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetsRequest model) {
            super(model);
            this.outpostIdentifier(model.outpostIdentifier);
            this.hostIdFilter(model.hostIdFilter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getOutpostIdentifier() {
            return this.outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final Collection<String> getHostIdFilter() {
            if (this.hostIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hostIdFilter;
        }

        public final void setHostIdFilter(Collection<String> hostIdFilter) {
            this.hostIdFilter = HostIdListCopier.copy(hostIdFilter);
        }

        @Override
        public final Builder hostIdFilter(Collection<String> hostIdFilter) {
            this.hostIdFilter = HostIdListCopier.copy(hostIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdFilter(String ... hostIdFilter) {
            this.hostIdFilter(Arrays.asList(hostIdFilter));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetsRequest build() {
            return new ListAssetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssetsRequest> {
        public Builder outpostIdentifier(String var1);

        public Builder hostIdFilter(Collection<String> var1);

        public Builder hostIdFilter(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

