/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CityListCopier;
import software.amazon.awssdk.services.outposts.model.CountryCodeListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.StateOrRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSitesRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListSitesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSitesRequest.getter(ListSitesRequest::nextToken)).setter(ListSitesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListSitesRequest.getter(ListSitesRequest::maxResults)).setter(ListSitesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> OPERATING_ADDRESS_COUNTRY_CODE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingAddressCountryCodeFilter").getter(ListSitesRequest.getter(ListSitesRequest::operatingAddressCountryCodeFilter)).setter(ListSitesRequest.setter(Builder::operatingAddressCountryCodeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OperatingAddressCountryCodeFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATING_ADDRESS_STATE_OR_REGION_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingAddressStateOrRegionFilter").getter(ListSitesRequest.getter(ListSitesRequest::operatingAddressStateOrRegionFilter)).setter(ListSitesRequest.setter(Builder::operatingAddressStateOrRegionFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OperatingAddressStateOrRegionFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATING_ADDRESS_CITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperatingAddressCityFilter").getter(ListSitesRequest.getter(ListSitesRequest::operatingAddressCityFilter)).setter(ListSitesRequest.setter(Builder::operatingAddressCityFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OperatingAddressCityFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, OPERATING_ADDRESS_COUNTRY_CODE_FILTER_FIELD, OPERATING_ADDRESS_STATE_OR_REGION_FILTER_FIELD, OPERATING_ADDRESS_CITY_FILTER_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> operatingAddressCountryCodeFilter;
    private final List<String> operatingAddressStateOrRegionFilter;
    private final List<String> operatingAddressCityFilter;

    private ListSitesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.operatingAddressCountryCodeFilter = builder.operatingAddressCountryCodeFilter;
        this.operatingAddressStateOrRegionFilter = builder.operatingAddressStateOrRegionFilter;
        this.operatingAddressCityFilter = builder.operatingAddressCityFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasOperatingAddressCountryCodeFilter() {
        return this.operatingAddressCountryCodeFilter != null && !(this.operatingAddressCountryCodeFilter instanceof SdkAutoConstructList);
    }

    public final List<String> operatingAddressCountryCodeFilter() {
        return this.operatingAddressCountryCodeFilter;
    }

    public final boolean hasOperatingAddressStateOrRegionFilter() {
        return this.operatingAddressStateOrRegionFilter != null && !(this.operatingAddressStateOrRegionFilter instanceof SdkAutoConstructList);
    }

    public final List<String> operatingAddressStateOrRegionFilter() {
        return this.operatingAddressStateOrRegionFilter;
    }

    public final boolean hasOperatingAddressCityFilter() {
        return this.operatingAddressCityFilter != null && !(this.operatingAddressCityFilter instanceof SdkAutoConstructList);
    }

    public final List<String> operatingAddressCityFilter() {
        return this.operatingAddressCityFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingAddressCountryCodeFilter() ? this.operatingAddressCountryCodeFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingAddressStateOrRegionFilter() ? this.operatingAddressStateOrRegionFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingAddressCityFilter() ? this.operatingAddressCityFilter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSitesRequest)) {
            return false;
        }
        ListSitesRequest other = (ListSitesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasOperatingAddressCountryCodeFilter() == other.hasOperatingAddressCountryCodeFilter() && Objects.equals(this.operatingAddressCountryCodeFilter(), other.operatingAddressCountryCodeFilter()) && this.hasOperatingAddressStateOrRegionFilter() == other.hasOperatingAddressStateOrRegionFilter() && Objects.equals(this.operatingAddressStateOrRegionFilter(), other.operatingAddressStateOrRegionFilter()) && this.hasOperatingAddressCityFilter() == other.hasOperatingAddressCityFilter() && Objects.equals(this.operatingAddressCityFilter(), other.operatingAddressCityFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListSitesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("OperatingAddressCountryCodeFilter", this.hasOperatingAddressCountryCodeFilter() ? this.operatingAddressCountryCodeFilter() : null).add("OperatingAddressStateOrRegionFilter", this.hasOperatingAddressStateOrRegionFilter() ? this.operatingAddressStateOrRegionFilter() : null).add("OperatingAddressCityFilter", this.hasOperatingAddressCityFilter() ? this.operatingAddressCityFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "OperatingAddressCountryCodeFilter": {
                return Optional.ofNullable(clazz.cast(this.operatingAddressCountryCodeFilter()));
            }
            case "OperatingAddressStateOrRegionFilter": {
                return Optional.ofNullable(clazz.cast(this.operatingAddressStateOrRegionFilter()));
            }
            case "OperatingAddressCityFilter": {
                return Optional.ofNullable(clazz.cast(this.operatingAddressCityFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSitesRequest, T> g) {
        return obj -> g.apply((ListSitesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<String> operatingAddressCountryCodeFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> operatingAddressStateOrRegionFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> operatingAddressCityFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSitesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.operatingAddressCountryCodeFilter(model.operatingAddressCountryCodeFilter);
            this.operatingAddressStateOrRegionFilter(model.operatingAddressStateOrRegionFilter);
            this.operatingAddressCityFilter(model.operatingAddressCityFilter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getOperatingAddressCountryCodeFilter() {
            if (this.operatingAddressCountryCodeFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operatingAddressCountryCodeFilter;
        }

        public final void setOperatingAddressCountryCodeFilter(Collection<String> operatingAddressCountryCodeFilter) {
            this.operatingAddressCountryCodeFilter = CountryCodeListCopier.copy(operatingAddressCountryCodeFilter);
        }

        @Override
        @Transient
        public final Builder operatingAddressCountryCodeFilter(Collection<String> operatingAddressCountryCodeFilter) {
            this.operatingAddressCountryCodeFilter = CountryCodeListCopier.copy(operatingAddressCountryCodeFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operatingAddressCountryCodeFilter(String ... operatingAddressCountryCodeFilter) {
            this.operatingAddressCountryCodeFilter(Arrays.asList(operatingAddressCountryCodeFilter));
            return this;
        }

        public final Collection<String> getOperatingAddressStateOrRegionFilter() {
            if (this.operatingAddressStateOrRegionFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operatingAddressStateOrRegionFilter;
        }

        public final void setOperatingAddressStateOrRegionFilter(Collection<String> operatingAddressStateOrRegionFilter) {
            this.operatingAddressStateOrRegionFilter = StateOrRegionListCopier.copy(operatingAddressStateOrRegionFilter);
        }

        @Override
        @Transient
        public final Builder operatingAddressStateOrRegionFilter(Collection<String> operatingAddressStateOrRegionFilter) {
            this.operatingAddressStateOrRegionFilter = StateOrRegionListCopier.copy(operatingAddressStateOrRegionFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operatingAddressStateOrRegionFilter(String ... operatingAddressStateOrRegionFilter) {
            this.operatingAddressStateOrRegionFilter(Arrays.asList(operatingAddressStateOrRegionFilter));
            return this;
        }

        public final Collection<String> getOperatingAddressCityFilter() {
            if (this.operatingAddressCityFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operatingAddressCityFilter;
        }

        public final void setOperatingAddressCityFilter(Collection<String> operatingAddressCityFilter) {
            this.operatingAddressCityFilter = CityListCopier.copy(operatingAddressCityFilter);
        }

        @Override
        @Transient
        public final Builder operatingAddressCityFilter(Collection<String> operatingAddressCityFilter) {
            this.operatingAddressCityFilter = CityListCopier.copy(operatingAddressCityFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder operatingAddressCityFilter(String ... operatingAddressCityFilter) {
            this.operatingAddressCityFilter(Arrays.asList(operatingAddressCityFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSitesRequest build() {
            return new ListSitesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSitesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder operatingAddressCountryCodeFilter(Collection<String> var1);

        public Builder operatingAddressCountryCodeFilter(String ... var1);

        public Builder operatingAddressStateOrRegionFilter(Collection<String> var1);

        public Builder operatingAddressStateOrRegionFilter(String ... var1);

        public Builder operatingAddressCityFilter(Collection<String> var1);

        public Builder operatingAddressCityFilter(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

