/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CatalogItemClass {
    RACK("RACK"),
    SERVER("SERVER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CatalogItemClass> VALUE_MAP;
    private final String value;

    private CatalogItemClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CatalogItemClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CatalogItemClass> knownValues() {
        EnumSet<CatalogItemClass> knownValues = EnumSet.allOf(CatalogItemClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CatalogItemClass.class, CatalogItemClass::toString);
    }
}

