/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.ListParentsRequest;
import software.amazon.awssdk.services.organizations.model.ListParentsResponse;

public class ListParentsPublisher
implements SdkPublisher<ListParentsResponse> {
    private final OrganizationsAsyncClient client;
    private final ListParentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListParentsPublisher(OrganizationsAsyncClient client, ListParentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListParentsPublisher(OrganizationsAsyncClient client, ListParentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListParentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListParentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListParentsPublisher resume(ListParentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListParentsPublisher(this.client, (ListParentsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListParentsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListParentsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListParentsResponseFetcher
    implements AsyncPageFetcher<ListParentsResponse> {
        private ListParentsResponseFetcher() {
        }

        public boolean hasNextPage(ListParentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListParentsResponse> nextPage(ListParentsResponse previousPage) {
            if (previousPage == null) {
                return ListParentsPublisher.this.client.listParents(ListParentsPublisher.this.firstRequest);
            }
            return ListParentsPublisher.this.client.listParents((ListParentsRequest)((Object)ListParentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

