/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.Deployment;
import software.amazon.awssdk.services.opsworks.model.DeploymentsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeploymentsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeDeploymentsResponse> {
    private static final SdkField<List<Deployment>> DEPLOYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDeploymentsResponse.getter(DescribeDeploymentsResponse::deployments)).setter(DescribeDeploymentsResponse.setter(Builder::deployments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Deployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_FIELD));
    private final List<Deployment> deployments;

    private DescribeDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
    }

    public List<Deployment> deployments() {
        return this.deployments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deployments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsResponse)) {
            return false;
        }
        DescribeDeploymentsResponse other = (DescribeDeploymentsResponse)((Object)obj);
        return Objects.equals(this.deployments(), other.deployments());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDeploymentsResponse").add("Deployments", this.deployments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Deployments": {
                return Optional.ofNullable(clazz.cast(this.deployments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeploymentsResponse, T> g) {
        return obj -> g.apply((DescribeDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsResponse model) {
            super(model);
            this.deployments(model.deployments);
        }

        public final Collection<Deployment.Builder> getDeployments() {
            return this.deployments != null ? (Collection)this.deployments.stream().map(Deployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder> ... deployments) {
            this.deployments(Stream.of(deployments).map(c -> (Deployment)((Deployment.Builder)Deployment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        @Override
        public DescribeDeploymentsResponse build() {
            return new DescribeDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeploymentsResponse> {
        public Builder deployments(Collection<Deployment> var1);

        public Builder deployments(Deployment ... var1);

        public Builder deployments(Consumer<Deployment.Builder> ... var1);
    }
}

