/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserProfilesRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeUserProfilesRequest> {
    private static final SdkField<List<String>> IAM_USER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeUserProfilesRequest.getter(DescribeUserProfilesRequest::iamUserArns)).setter(DescribeUserProfilesRequest.setter(Builder::iamUserArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARNS_FIELD));
    private final List<String> iamUserArns;

    private DescribeUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArns = builder.iamUserArns;
    }

    public List<String> iamUserArns() {
        return this.iamUserArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesRequest)) {
            return false;
        }
        DescribeUserProfilesRequest other = (DescribeUserProfilesRequest)((Object)obj);
        return Objects.equals(this.iamUserArns(), other.iamUserArns());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserProfilesRequest").add("IamUserArns", this.iamUserArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IamUserArns": {
                return Optional.ofNullable(clazz.cast(this.iamUserArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfilesRequest, T> g) {
        return obj -> g.apply((DescribeUserProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private List<String> iamUserArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesRequest model) {
            super(model);
            this.iamUserArns(model.iamUserArns);
        }

        public final Collection<String> getIamUserArns() {
            return this.iamUserArns;
        }

        @Override
        public final Builder iamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamUserArns(String ... iamUserArns) {
            this.iamUserArns(Arrays.asList(iamUserArns));
            return this;
        }

        public final void setIamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserProfilesRequest build() {
            return new DescribeUserProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserProfilesRequest> {
        public Builder iamUserArns(Collection<String> var1);

        public Builder iamUserArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

