/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoScalingType {
    LOAD("load"),
    TIMER("timer"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoScalingType> VALUE_MAP;
    private final String value;

    private AutoScalingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoScalingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoScalingType> knownValues() {
        EnumSet<AutoScalingType> knownValues = EnumSet.allOf(AutoScalingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoScalingType.class, AutoScalingType::toString);
    }
}

