/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeConfiguration> {
    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeConfiguration.getter(VolumeConfiguration::mountPoint)).setter(VolumeConfiguration.setter(Builder::mountPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoint").build()}).build();
    private static final SdkField<Integer> RAID_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeConfiguration.getter(VolumeConfiguration::raidLevel)).setter(VolumeConfiguration.setter(Builder::raidLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidLevel").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeConfiguration.getter(VolumeConfiguration::numberOfDisks)).setter(VolumeConfiguration.setter(Builder::numberOfDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDisks").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeConfiguration.getter(VolumeConfiguration::size)).setter(VolumeConfiguration.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VolumeConfiguration.getter(VolumeConfiguration::volumeType)).setter(VolumeConfiguration.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(VolumeConfiguration.getter(VolumeConfiguration::iops)).setter(VolumeConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(VolumeConfiguration.getter(VolumeConfiguration::encrypted)).setter(VolumeConfiguration.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MOUNT_POINT_FIELD, RAID_LEVEL_FIELD, NUMBER_OF_DISKS_FIELD, SIZE_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD, ENCRYPTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mountPoint;
    private final Integer raidLevel;
    private final Integer numberOfDisks;
    private final Integer size;
    private final String volumeType;
    private final Integer iops;
    private final Boolean encrypted;

    private VolumeConfiguration(BuilderImpl builder) {
        this.mountPoint = builder.mountPoint;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
    }

    public String mountPoint() {
        return this.mountPoint;
    }

    public Integer raidLevel() {
        return this.raidLevel;
    }

    public Integer numberOfDisks() {
        return this.numberOfDisks;
    }

    public Integer size() {
        return this.size;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.raidLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDisks());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration)obj;
        return Objects.equals(this.mountPoint(), other.mountPoint()) && Objects.equals(this.raidLevel(), other.raidLevel()) && Objects.equals(this.numberOfDisks(), other.numberOfDisks()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.encrypted(), other.encrypted());
    }

    public String toString() {
        return ToString.builder((String)"VolumeConfiguration").add("MountPoint", (Object)this.mountPoint()).add("RaidLevel", (Object)this.raidLevel()).add("NumberOfDisks", (Object)this.numberOfDisks()).add("Size", (Object)this.size()).add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).add("Encrypted", (Object)this.encrypted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MountPoint": {
                return Optional.ofNullable(clazz.cast(this.mountPoint()));
            }
            case "RaidLevel": {
                return Optional.ofNullable(clazz.cast(this.raidLevel()));
            }
            case "NumberOfDisks": {
                return Optional.ofNullable(clazz.cast(this.numberOfDisks()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeConfiguration, T> g) {
        return obj -> g.apply((VolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mountPoint;
        private Integer raidLevel;
        private Integer numberOfDisks;
        private Integer size;
        private String volumeType;
        private Integer iops;
        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            this.mountPoint(model.mountPoint);
            this.raidLevel(model.raidLevel);
            this.numberOfDisks(model.numberOfDisks);
            this.size(model.size);
            this.volumeType(model.volumeType);
            this.iops(model.iops);
            this.encrypted(model.encrypted);
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final Integer getRaidLevel() {
            return this.raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return this.numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeConfiguration> {
        public Builder mountPoint(String var1);

        public Builder raidLevel(Integer var1);

        public Builder numberOfDisks(Integer var1);

        public Builder size(Integer var1);

        public Builder volumeType(String var1);

        public Builder iops(Integer var1);

        public Builder encrypted(Boolean var1);
    }
}

