/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.WeeklyAutoScalingSchedule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeBasedAutoScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeBasedAutoScalingConfiguration> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(TimeBasedAutoScalingConfiguration.getter(TimeBasedAutoScalingConfiguration::instanceId)).setter(TimeBasedAutoScalingConfiguration.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<WeeklyAutoScalingSchedule> AUTO_SCALING_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoScalingSchedule").getter(TimeBasedAutoScalingConfiguration.getter(TimeBasedAutoScalingConfiguration::autoScalingSchedule)).setter(TimeBasedAutoScalingConfiguration.setter(Builder::autoScalingSchedule)).constructor(WeeklyAutoScalingSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingSchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, AUTO_SCALING_SCHEDULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final WeeklyAutoScalingSchedule autoScalingSchedule;

    private TimeBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingSchedule = builder.autoScalingSchedule;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final WeeklyAutoScalingSchedule autoScalingSchedule() {
        return this.autoScalingSchedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingSchedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedAutoScalingConfiguration)) {
            return false;
        }
        TimeBasedAutoScalingConfiguration other = (TimeBasedAutoScalingConfiguration)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.autoScalingSchedule(), other.autoScalingSchedule());
    }

    public final String toString() {
        return ToString.builder((String)"TimeBasedAutoScalingConfiguration").add("InstanceId", (Object)this.instanceId()).add("AutoScalingSchedule", (Object)this.autoScalingSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AutoScalingSchedule": {
                return Optional.ofNullable(clazz.cast(this.autoScalingSchedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedAutoScalingConfiguration, T> g) {
        return obj -> g.apply((TimeBasedAutoScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private WeeklyAutoScalingSchedule autoScalingSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedAutoScalingConfiguration model) {
            this.instanceId(model.instanceId);
            this.autoScalingSchedule(model.autoScalingSchedule);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final WeeklyAutoScalingSchedule.Builder getAutoScalingSchedule() {
            return this.autoScalingSchedule != null ? this.autoScalingSchedule.toBuilder() : null;
        }

        public final void setAutoScalingSchedule(WeeklyAutoScalingSchedule.BuilderImpl autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule != null ? autoScalingSchedule.build() : null;
        }

        @Override
        public final Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule;
            return this;
        }

        public TimeBasedAutoScalingConfiguration build() {
            return new TimeBasedAutoScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeBasedAutoScalingConfiguration> {
        public Builder instanceId(String var1);

        public Builder autoScalingSchedule(WeeklyAutoScalingSchedule var1);

        default public Builder autoScalingSchedule(Consumer<WeeklyAutoScalingSchedule.Builder> autoScalingSchedule) {
            return this.autoScalingSchedule((WeeklyAutoScalingSchedule)((WeeklyAutoScalingSchedule.Builder)WeeklyAutoScalingSchedule.builder().applyMutation(autoScalingSchedule)).build());
        }
    }
}

