/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsConfiguration;
import software.amazon.awssdk.services.opsworks.model.LayerAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.LayerAttributesKeys;
import software.amazon.awssdk.services.opsworks.model.LayerType;
import software.amazon.awssdk.services.opsworks.model.LifecycleEventConfiguration;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.Recipes;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.services.opsworks.model.VolumeConfiguration;
import software.amazon.awssdk.services.opsworks.model.VolumeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLayerRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, CreateLayerRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLayerRequest.getter(CreateLayerRequest::stackId)).setter(CreateLayerRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLayerRequest.getter(CreateLayerRequest::typeAsString)).setter(CreateLayerRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLayerRequest.getter(CreateLayerRequest::name)).setter(CreateLayerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SHORTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLayerRequest.getter(CreateLayerRequest::shortname)).setter(CreateLayerRequest.setter(Builder::shortname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shortname").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateLayerRequest.getter(CreateLayerRequest::attributesAsStrings)).setter(CreateLayerRequest.setter(Builder::attributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<CloudWatchLogsConfiguration> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLayerRequest.getter(CreateLayerRequest::cloudWatchLogsConfiguration)).setter(CreateLayerRequest.setter(Builder::cloudWatchLogsConfiguration)).constructor(CloudWatchLogsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration").build()}).build();
    private static final SdkField<String> CUSTOM_INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLayerRequest.getter(CreateLayerRequest::customInstanceProfileArn)).setter(CreateLayerRequest.setter(Builder::customInstanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomInstanceProfileArn").build()}).build();
    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateLayerRequest.getter(CreateLayerRequest::customJson)).setter(CreateLayerRequest.setter(Builder::customJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()}).build();
    private static final SdkField<List<String>> CUSTOM_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLayerRequest.getter(CreateLayerRequest::customSecurityGroupIds)).setter(CreateLayerRequest.setter(Builder::customSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLayerRequest.getter(CreateLayerRequest::packages)).setter(CreateLayerRequest.setter(Builder::packages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Packages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateLayerRequest.getter(CreateLayerRequest::volumeConfigurations)).setter(CreateLayerRequest.setter(Builder::volumeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_HEALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLayerRequest.getter(CreateLayerRequest::enableAutoHealing)).setter(CreateLayerRequest.setter(Builder::enableAutoHealing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAutoHealing").build()}).build();
    private static final SdkField<Boolean> AUTO_ASSIGN_ELASTIC_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLayerRequest.getter(CreateLayerRequest::autoAssignElasticIps)).setter(CreateLayerRequest.setter(Builder::autoAssignElasticIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssignElasticIps").build()}).build();
    private static final SdkField<Boolean> AUTO_ASSIGN_PUBLIC_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLayerRequest.getter(CreateLayerRequest::autoAssignPublicIps)).setter(CreateLayerRequest.setter(Builder::autoAssignPublicIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssignPublicIps").build()}).build();
    private static final SdkField<Recipes> CUSTOM_RECIPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLayerRequest.getter(CreateLayerRequest::customRecipes)).setter(CreateLayerRequest.setter(Builder::customRecipes)).constructor(Recipes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRecipes").build()}).build();
    private static final SdkField<Boolean> INSTALL_UPDATES_ON_BOOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLayerRequest.getter(CreateLayerRequest::installUpdatesOnBoot)).setter(CreateLayerRequest.setter(Builder::installUpdatesOnBoot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallUpdatesOnBoot").build()}).build();
    private static final SdkField<Boolean> USE_EBS_OPTIMIZED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateLayerRequest.getter(CreateLayerRequest::useEbsOptimizedInstances)).setter(CreateLayerRequest.setter(Builder::useEbsOptimizedInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseEbsOptimizedInstances").build()}).build();
    private static final SdkField<LifecycleEventConfiguration> LIFECYCLE_EVENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateLayerRequest.getter(CreateLayerRequest::lifecycleEventConfiguration)).setter(CreateLayerRequest.setter(Builder::lifecycleEventConfiguration)).constructor(LifecycleEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleEventConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, TYPE_FIELD, NAME_FIELD, SHORTNAME_FIELD, ATTRIBUTES_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD, CUSTOM_INSTANCE_PROFILE_ARN_FIELD, CUSTOM_JSON_FIELD, CUSTOM_SECURITY_GROUP_IDS_FIELD, PACKAGES_FIELD, VOLUME_CONFIGURATIONS_FIELD, ENABLE_AUTO_HEALING_FIELD, AUTO_ASSIGN_ELASTIC_IPS_FIELD, AUTO_ASSIGN_PUBLIC_IPS_FIELD, CUSTOM_RECIPES_FIELD, INSTALL_UPDATES_ON_BOOT_FIELD, USE_EBS_OPTIMIZED_INSTANCES_FIELD, LIFECYCLE_EVENT_CONFIGURATION_FIELD));
    private final String stackId;
    private final String type;
    private final String name;
    private final String shortname;
    private final Map<String, String> attributes;
    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;
    private final String customInstanceProfileArn;
    private final String customJson;
    private final List<String> customSecurityGroupIds;
    private final List<String> packages;
    private final List<VolumeConfiguration> volumeConfigurations;
    private final Boolean enableAutoHealing;
    private final Boolean autoAssignElasticIps;
    private final Boolean autoAssignPublicIps;
    private final Recipes customRecipes;
    private final Boolean installUpdatesOnBoot;
    private final Boolean useEbsOptimizedInstances;
    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private CreateLayerRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.type = builder.type;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.customRecipes = builder.customRecipes;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    public String stackId() {
        return this.stackId;
    }

    public LayerType type() {
        return LayerType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String shortname() {
        return this.shortname;
    }

    public Map<LayerAttributesKeys, String> attributes() {
        return TypeConverter.convert(this.attributes, LayerAttributesKeys::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)LayerAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return this.cloudWatchLogsConfiguration;
    }

    public String customInstanceProfileArn() {
        return this.customInstanceProfileArn;
    }

    public String customJson() {
        return this.customJson;
    }

    public List<String> customSecurityGroupIds() {
        return this.customSecurityGroupIds;
    }

    public List<String> packages() {
        return this.packages;
    }

    public List<VolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    public Boolean enableAutoHealing() {
        return this.enableAutoHealing;
    }

    public Boolean autoAssignElasticIps() {
        return this.autoAssignElasticIps;
    }

    public Boolean autoAssignPublicIps() {
        return this.autoAssignPublicIps;
    }

    public Recipes customRecipes() {
        return this.customRecipes;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean useEbsOptimizedInstances() {
        return this.useEbsOptimizedInstances;
    }

    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return this.lifecycleEventConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortname());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customJson());
        hashCode = 31 * hashCode + Objects.hashCode(this.customSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.packages());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoHealing());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssignElasticIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAssignPublicIps());
        hashCode = 31 * hashCode + Objects.hashCode(this.customRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(this.installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(this.useEbsOptimizedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEventConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLayerRequest)) {
            return false;
        }
        CreateLayerRequest other = (CreateLayerRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.shortname(), other.shortname()) && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings()) && Objects.equals(this.cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration()) && Objects.equals(this.customInstanceProfileArn(), other.customInstanceProfileArn()) && Objects.equals(this.customJson(), other.customJson()) && Objects.equals(this.customSecurityGroupIds(), other.customSecurityGroupIds()) && Objects.equals(this.packages(), other.packages()) && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations()) && Objects.equals(this.enableAutoHealing(), other.enableAutoHealing()) && Objects.equals(this.autoAssignElasticIps(), other.autoAssignElasticIps()) && Objects.equals(this.autoAssignPublicIps(), other.autoAssignPublicIps()) && Objects.equals(this.customRecipes(), other.customRecipes()) && Objects.equals(this.installUpdatesOnBoot(), other.installUpdatesOnBoot()) && Objects.equals(this.useEbsOptimizedInstances(), other.useEbsOptimizedInstances()) && Objects.equals(this.lifecycleEventConfiguration(), other.lifecycleEventConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateLayerRequest").add("StackId", (Object)this.stackId()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Shortname", (Object)this.shortname()).add("Attributes", this.attributesAsStrings()).add("CloudWatchLogsConfiguration", (Object)this.cloudWatchLogsConfiguration()).add("CustomInstanceProfileArn", (Object)this.customInstanceProfileArn()).add("CustomJson", (Object)this.customJson()).add("CustomSecurityGroupIds", this.customSecurityGroupIds()).add("Packages", this.packages()).add("VolumeConfigurations", this.volumeConfigurations()).add("EnableAutoHealing", (Object)this.enableAutoHealing()).add("AutoAssignElasticIps", (Object)this.autoAssignElasticIps()).add("AutoAssignPublicIps", (Object)this.autoAssignPublicIps()).add("CustomRecipes", (Object)this.customRecipes()).add("InstallUpdatesOnBoot", (Object)this.installUpdatesOnBoot()).add("UseEbsOptimizedInstances", (Object)this.useEbsOptimizedInstances()).add("LifecycleEventConfiguration", (Object)this.lifecycleEventConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Shortname": {
                return Optional.ofNullable(clazz.cast(this.shortname()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
            case "CloudWatchLogsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsConfiguration()));
            }
            case "CustomInstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.customInstanceProfileArn()));
            }
            case "CustomJson": {
                return Optional.ofNullable(clazz.cast(this.customJson()));
            }
            case "CustomSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.customSecurityGroupIds()));
            }
            case "Packages": {
                return Optional.ofNullable(clazz.cast(this.packages()));
            }
            case "VolumeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.volumeConfigurations()));
            }
            case "EnableAutoHealing": {
                return Optional.ofNullable(clazz.cast(this.enableAutoHealing()));
            }
            case "AutoAssignElasticIps": {
                return Optional.ofNullable(clazz.cast(this.autoAssignElasticIps()));
            }
            case "AutoAssignPublicIps": {
                return Optional.ofNullable(clazz.cast(this.autoAssignPublicIps()));
            }
            case "CustomRecipes": {
                return Optional.ofNullable(clazz.cast(this.customRecipes()));
            }
            case "InstallUpdatesOnBoot": {
                return Optional.ofNullable(clazz.cast(this.installUpdatesOnBoot()));
            }
            case "UseEbsOptimizedInstances": {
                return Optional.ofNullable(clazz.cast(this.useEbsOptimizedInstances()));
            }
            case "LifecycleEventConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEventConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLayerRequest, T> g) {
        return obj -> g.apply((CreateLayerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String type;
        private String name;
        private String shortname;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;
        private String customInstanceProfileArn;
        private String customJson;
        private List<String> customSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> packages = DefaultSdkAutoConstructList.getInstance();
        private List<VolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableAutoHealing;
        private Boolean autoAssignElasticIps;
        private Boolean autoAssignPublicIps;
        private Recipes customRecipes;
        private Boolean installUpdatesOnBoot;
        private Boolean useEbsOptimizedInstances;
        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLayerRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.type(model.type);
            this.name(model.name);
            this.shortname(model.shortname);
            this.attributesWithStrings(model.attributes);
            this.cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            this.customInstanceProfileArn(model.customInstanceProfileArn);
            this.customJson(model.customJson);
            this.customSecurityGroupIds(model.customSecurityGroupIds);
            this.packages(model.packages);
            this.volumeConfigurations(model.volumeConfigurations);
            this.enableAutoHealing(model.enableAutoHealing);
            this.autoAssignElasticIps(model.autoAssignElasticIps);
            this.autoAssignPublicIps(model.autoAssignPublicIps);
            this.customRecipes(model.customRecipes);
            this.installUpdatesOnBoot(model.installUpdatesOnBoot);
            this.useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            this.lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LayerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return this.shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<LayerAttributesKeys, String> attributes) {
            this.attributes = LayerAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return this.cloudWatchLogsConfiguration != null ? this.cloudWatchLogsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        public final String getCustomInstanceProfileArn() {
            return this.customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return this.customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String ... customSecurityGroupIds) {
            this.customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        public final Collection<String> getPackages() {
            return this.packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String ... packages) {
            this.packages(Arrays.asList(packages));
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        public final Collection<VolumeConfiguration.Builder> getVolumeConfigurations() {
            return this.volumeConfigurations != null ? (Collection)this.volumeConfigurations.stream().map(VolumeConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (VolumeConfiguration)((VolumeConfiguration.Builder)VolumeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        public final Boolean getEnableAutoHealing() {
            return this.enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return this.autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return this.autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes.Builder getCustomRecipes() {
            return this.customRecipes != null ? this.customRecipes.toBuilder() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return this.useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return this.lifecycleEventConfiguration != null ? this.lifecycleEventConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLayerRequest build() {
            return new CreateLayerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLayerRequest> {
        public Builder stackId(String var1);

        public Builder type(String var1);

        public Builder type(LayerType var1);

        public Builder name(String var1);

        public Builder shortname(String var1);

        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<LayerAttributesKeys, String> var1);

        public Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration var1);

        default public Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfiguration.Builder> cloudWatchLogsConfiguration) {
            return this.cloudWatchLogsConfiguration((CloudWatchLogsConfiguration)((CloudWatchLogsConfiguration.Builder)CloudWatchLogsConfiguration.builder().applyMutation(cloudWatchLogsConfiguration)).build());
        }

        public Builder customInstanceProfileArn(String var1);

        public Builder customJson(String var1);

        public Builder customSecurityGroupIds(Collection<String> var1);

        public Builder customSecurityGroupIds(String ... var1);

        public Builder packages(Collection<String> var1);

        public Builder packages(String ... var1);

        public Builder volumeConfigurations(Collection<VolumeConfiguration> var1);

        public Builder volumeConfigurations(VolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder> ... var1);

        public Builder enableAutoHealing(Boolean var1);

        public Builder autoAssignElasticIps(Boolean var1);

        public Builder autoAssignPublicIps(Boolean var1);

        public Builder customRecipes(Recipes var1);

        default public Builder customRecipes(Consumer<Recipes.Builder> customRecipes) {
            return this.customRecipes((Recipes)((Recipes.Builder)Recipes.builder().applyMutation(customRecipes)).build());
        }

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder useEbsOptimizedInstances(Boolean var1);

        public Builder lifecycleEventConfiguration(LifecycleEventConfiguration var1);

        default public Builder lifecycleEventConfiguration(Consumer<LifecycleEventConfiguration.Builder> lifecycleEventConfiguration) {
            return this.lifecycleEventConfiguration((LifecycleEventConfiguration)((LifecycleEventConfiguration.Builder)LifecycleEventConfiguration.builder().applyMutation(lifecycleEventConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

