/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opensearchserverless.endpoints.OpenSearchServerlessEndpointParams;
import software.amazon.awssdk.services.opensearchserverless.endpoints.OpenSearchServerlessEndpointProvider;
import software.amazon.awssdk.services.opensearchserverless.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.opensearchserverless.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.opensearchserverless.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultOpenSearchServerlessEndpointProvider
implements OpenSearchServerlessEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(OpenSearchServerlessEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(OpenSearchServerlessEndpointParams params, String region) {
        RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultOpenSearchServerlessEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(OpenSearchServerlessEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultOpenSearchServerlessEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(OpenSearchServerlessEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(OpenSearchServerlessEndpointParams params, String region) {
        RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(OpenSearchServerlessEndpointParams params, String region) {
        if (region != null) {
            return DefaultOpenSearchServerlessEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(OpenSearchServerlessEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule9(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOpenSearchServerlessEndpointProvider.endpointRule14(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultOpenSearchServerlessEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return DefaultOpenSearchServerlessEndpointProvider.endpointRule24(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(OpenSearchServerlessEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule10(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(OpenSearchServerlessEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return DefaultOpenSearchServerlessEndpointProvider.endpointRule11(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(OpenSearchServerlessEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://aoss-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule14(OpenSearchServerlessEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule15(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(OpenSearchServerlessEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return DefaultOpenSearchServerlessEndpointProvider.endpointRule16(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(OpenSearchServerlessEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://aoss-fips." + region + "." + partitionResult.dnsSuffix())).build());
    }

    private static RuleResult endpointRule19(OpenSearchServerlessEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultOpenSearchServerlessEndpointProvider.endpointRule20(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(OpenSearchServerlessEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return DefaultOpenSearchServerlessEndpointProvider.endpointRule21(params, region, partitionResult);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(OpenSearchServerlessEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://aoss." + region + "." + partitionResult.dualStackDnsSuffix())).build());
    }

    private static RuleResult endpointRule24(OpenSearchServerlessEndpointParams params, String region, RulePartition partitionResult) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://aoss." + region + "." + partitionResult.dnsSuffix())).build());
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

