/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetailsCopier;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCollectionResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, BatchGetCollectionResponse> {
    private static final SdkField<List<CollectionDetail>> COLLECTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collectionDetails").getter(BatchGetCollectionResponse.getter(BatchGetCollectionResponse::collectionDetails)).setter(BatchGetCollectionResponse.setter(Builder::collectionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CollectionErrorDetail>> COLLECTION_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("collectionErrorDetails").getter(BatchGetCollectionResponse.getter(BatchGetCollectionResponse::collectionErrorDetails)).setter(BatchGetCollectionResponse.setter(Builder::collectionErrorDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionErrorDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectionErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_DETAILS_FIELD, COLLECTION_ERROR_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCollectionResponse.memberNameToFieldInitializer();
    private final List<CollectionDetail> collectionDetails;
    private final List<CollectionErrorDetail> collectionErrorDetails;

    private BatchGetCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionDetails = builder.collectionDetails;
        this.collectionErrorDetails = builder.collectionErrorDetails;
    }

    public final boolean hasCollectionDetails() {
        return this.collectionDetails != null && !(this.collectionDetails instanceof SdkAutoConstructList);
    }

    public final List<CollectionDetail> collectionDetails() {
        return this.collectionDetails;
    }

    public final boolean hasCollectionErrorDetails() {
        return this.collectionErrorDetails != null && !(this.collectionErrorDetails instanceof SdkAutoConstructList);
    }

    public final List<CollectionErrorDetail> collectionErrorDetails() {
        return this.collectionErrorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionDetails() ? this.collectionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectionErrorDetails() ? this.collectionErrorDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCollectionResponse)) {
            return false;
        }
        BatchGetCollectionResponse other = (BatchGetCollectionResponse)((Object)obj);
        return this.hasCollectionDetails() == other.hasCollectionDetails() && Objects.equals(this.collectionDetails(), other.collectionDetails()) && this.hasCollectionErrorDetails() == other.hasCollectionErrorDetails() && Objects.equals(this.collectionErrorDetails(), other.collectionErrorDetails());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCollectionResponse").add("CollectionDetails", this.hasCollectionDetails() ? this.collectionDetails() : null).add("CollectionErrorDetails", this.hasCollectionErrorDetails() ? this.collectionErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collectionDetails": {
                return Optional.ofNullable(clazz.cast(this.collectionDetails()));
            }
            case "collectionErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.collectionErrorDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collectionDetails", COLLECTION_DETAILS_FIELD);
        map.put("collectionErrorDetails", COLLECTION_ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCollectionResponse, T> g) {
        return obj -> g.apply((BatchGetCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<CollectionDetail> collectionDetails = DefaultSdkAutoConstructList.getInstance();
        private List<CollectionErrorDetail> collectionErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCollectionResponse model) {
            super(model);
            this.collectionDetails(model.collectionDetails);
            this.collectionErrorDetails(model.collectionErrorDetails);
        }

        public final List<CollectionDetail.Builder> getCollectionDetails() {
            List<CollectionDetail.Builder> result = CollectionDetailsCopier.copyToBuilder(this.collectionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectionDetails(Collection<CollectionDetail.BuilderImpl> collectionDetails) {
            this.collectionDetails = CollectionDetailsCopier.copyFromBuilder(collectionDetails);
        }

        @Override
        public final Builder collectionDetails(Collection<CollectionDetail> collectionDetails) {
            this.collectionDetails = CollectionDetailsCopier.copy(collectionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionDetails(CollectionDetail ... collectionDetails) {
            this.collectionDetails(Arrays.asList(collectionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionDetails(Consumer<CollectionDetail.Builder> ... collectionDetails) {
            this.collectionDetails(Stream.of(collectionDetails).map(c -> (CollectionDetail)((CollectionDetail.Builder)CollectionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CollectionErrorDetail.Builder> getCollectionErrorDetails() {
            List<CollectionErrorDetail.Builder> result = CollectionErrorDetailsCopier.copyToBuilder(this.collectionErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectionErrorDetails(Collection<CollectionErrorDetail.BuilderImpl> collectionErrorDetails) {
            this.collectionErrorDetails = CollectionErrorDetailsCopier.copyFromBuilder(collectionErrorDetails);
        }

        @Override
        public final Builder collectionErrorDetails(Collection<CollectionErrorDetail> collectionErrorDetails) {
            this.collectionErrorDetails = CollectionErrorDetailsCopier.copy(collectionErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionErrorDetails(CollectionErrorDetail ... collectionErrorDetails) {
            this.collectionErrorDetails(Arrays.asList(collectionErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionErrorDetails(Consumer<CollectionErrorDetail.Builder> ... collectionErrorDetails) {
            this.collectionErrorDetails(Stream.of(collectionErrorDetails).map(c -> (CollectionErrorDetail)((CollectionErrorDetail.Builder)CollectionErrorDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCollectionResponse build() {
            return new BatchGetCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCollectionResponse> {
        public Builder collectionDetails(Collection<CollectionDetail> var1);

        public Builder collectionDetails(CollectionDetail ... var1);

        public Builder collectionDetails(Consumer<CollectionDetail.Builder> ... var1);

        public Builder collectionErrorDetails(Collection<CollectionErrorDetail> var1);

        public Builder collectionErrorDetails(CollectionErrorDetail ... var1);

        public Builder collectionErrorDetails(Consumer<CollectionErrorDetail.Builder> ... var1);
    }
}

