/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityPolicyDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityPolicyDetail> {
    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("createdDate").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::createdDate)).setter(SecurityPolicyDetail.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::description)).setter(SecurityPolicyDetail.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedDate").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::lastModifiedDate)).setter(SecurityPolicyDetail.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::name)).setter(SecurityPolicyDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Document> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("policy").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::policy)).setter(SecurityPolicyDetail.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<String> POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyVersion").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::policyVersion)).setter(SecurityPolicyDetail.setter(Builder::policyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersion").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SecurityPolicyDetail.getter(SecurityPolicyDetail::typeAsString)).setter(SecurityPolicyDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD, POLICY_FIELD, POLICY_VERSION_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long createdDate;
    private final String description;
    private final Long lastModifiedDate;
    private final String name;
    private final Document policy;
    private final String policyVersion;
    private final String type;

    private SecurityPolicyDetail(BuilderImpl builder) {
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.policy = builder.policy;
        this.policyVersion = builder.policyVersion;
        this.type = builder.type;
    }

    public final Long createdDate() {
        return this.createdDate;
    }

    public final String description() {
        return this.description;
    }

    public final Long lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String name() {
        return this.name;
    }

    public final Document policy() {
        return this.policy;
    }

    public final String policyVersion() {
        return this.policyVersion;
    }

    public final SecurityPolicyType type() {
        return SecurityPolicyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityPolicyDetail)) {
            return false;
        }
        SecurityPolicyDetail other = (SecurityPolicyDetail)obj;
        return Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.policyVersion(), other.policyVersion()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityPolicyDetail").add("CreatedDate", (Object)this.createdDate()).add("Description", (Object)this.description()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Name", (Object)this.name()).add("Policy", (Object)this.policy()).add("PolicyVersion", (Object)this.policyVersion()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "policyVersion": {
                return Optional.ofNullable(clazz.cast(this.policyVersion()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityPolicyDetail, T> g) {
        return obj -> g.apply((SecurityPolicyDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long createdDate;
        private String description;
        private Long lastModifiedDate;
        private String name;
        private Document policy;
        private String policyVersion;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityPolicyDetail model) {
            this.createdDate(model.createdDate);
            this.description(model.description);
            this.lastModifiedDate(model.lastModifiedDate);
            this.name(model.name);
            this.policy(model.policy);
            this.policyVersion(model.policyVersion);
            this.type(model.type);
        }

        public final Long getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Document getPolicy() {
            return this.policy;
        }

        public final void setPolicy(Document policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(Document policy) {
            this.policy = policy;
            return this;
        }

        public final String getPolicyVersion() {
            return this.policyVersion;
        }

        public final void setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
        }

        @Override
        public final Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SecurityPolicyDetail build() {
            return new SecurityPolicyDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityPolicyDetail> {
        public Builder createdDate(Long var1);

        public Builder description(String var1);

        public Builder lastModifiedDate(Long var1);

        public Builder name(String var1);

        public Builder policy(Document var1);

        public Builder policyVersion(String var1);

        public Builder type(String var1);

        public Builder type(SecurityPolicyType var1);
    }
}

