/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollectionsRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<ListCollectionsRequest.Builder, ListCollectionsRequest> {
    private static final SdkField<CollectionFilters> COLLECTION_FILTERS_FIELD = SdkField
            .<CollectionFilters> builder(MarshallingType.SDK_POJO).memberName("collectionFilters")
            .getter(getter(ListCollectionsRequest::collectionFilters)).setter(setter(Builder::collectionFilters))
            .constructor(CollectionFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionFilters").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCollectionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollectionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final CollectionFilters collectionFilters;

    private final Integer maxResults;

    private final String nextToken;

    private ListCollectionsRequest(BuilderImpl builder) {
        super(builder);
        this.collectionFilters = builder.collectionFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List of filter names and values that you can use for requests.
     * </p>
     * 
     * @return List of filter names and values that you can use for requests.
     */
    public final CollectionFilters collectionFilters() {
        return collectionFilters;
    }

    /**
     * <p>
     * The maximum number of results to return. Default is 20. You can use <code>nextToken</code> to get the next page
     * of results.
     * </p>
     * 
     * @return The maximum number of results to return. Default is 20. You can use <code>nextToken</code> to get the
     *         next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If your initial <code>ListCollections</code> operation returns a <code>nextToken</code>, you can include the
     * returned <code>nextToken</code> in subsequent <code>ListCollections</code> operations, which returns results in
     * the next page.
     * </p>
     * 
     * @return If your initial <code>ListCollections</code> operation returns a <code>nextToken</code>, you can include
     *         the returned <code>nextToken</code> in subsequent <code>ListCollections</code> operations, which returns
     *         results in the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collectionFilters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsRequest)) {
            return false;
        }
        ListCollectionsRequest other = (ListCollectionsRequest) obj;
        return Objects.equals(collectionFilters(), other.collectionFilters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCollectionsRequest").add("CollectionFilters", collectionFilters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collectionFilters":
            return Optional.ofNullable(clazz.cast(collectionFilters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCollectionsRequest, T> g) {
        return obj -> g.apply((ListCollectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollectionsRequest> {
        /**
         * <p>
         * List of filter names and values that you can use for requests.
         * </p>
         * 
         * @param collectionFilters
         *        List of filter names and values that you can use for requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionFilters(CollectionFilters collectionFilters);

        /**
         * <p>
         * List of filter names and values that you can use for requests.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollectionFilters.Builder} avoiding the
         * need to create one manually via {@link CollectionFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollectionFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #collectionFilters(CollectionFilters)}.
         * 
         * @param collectionFilters
         *        a consumer that will call methods on {@link CollectionFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectionFilters(CollectionFilters)
         */
        default Builder collectionFilters(Consumer<CollectionFilters.Builder> collectionFilters) {
            return collectionFilters(CollectionFilters.builder().applyMutation(collectionFilters).build());
        }

        /**
         * <p>
         * The maximum number of results to return. Default is 20. You can use <code>nextToken</code> to get the next
         * page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return. Default is 20. You can use <code>nextToken</code> to get the
         *        next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If your initial <code>ListCollections</code> operation returns a <code>nextToken</code>, you can include the
         * returned <code>nextToken</code> in subsequent <code>ListCollections</code> operations, which returns results
         * in the next page.
         * </p>
         * 
         * @param nextToken
         *        If your initial <code>ListCollections</code> operation returns a <code>nextToken</code>, you can
         *        include the returned <code>nextToken</code> in subsequent <code>ListCollections</code> operations,
         *        which returns results in the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private CollectionFilters collectionFilters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollectionsRequest model) {
            super(model);
            collectionFilters(model.collectionFilters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final CollectionFilters.Builder getCollectionFilters() {
            return collectionFilters != null ? collectionFilters.toBuilder() : null;
        }

        public final void setCollectionFilters(CollectionFilters.BuilderImpl collectionFilters) {
            this.collectionFilters = collectionFilters != null ? collectionFilters.build() : null;
        }

        @Override
        public final Builder collectionFilters(CollectionFilters collectionFilters) {
            this.collectionFilters = collectionFilters;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCollectionsRequest build() {
            return new ListCollectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
