/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse;

public class ListCollectionsIterable
implements SdkIterable<ListCollectionsResponse> {
    private final OpenSearchServerlessClient client;
    private final ListCollectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollectionsIterable(OpenSearchServerlessClient client, ListCollectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCollectionsResponseFetcher();
    }

    public Iterator<ListCollectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCollectionsResponseFetcher
    implements SyncPageFetcher<ListCollectionsResponse> {
        private ListCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollectionsResponse nextPage(ListCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectionsIterable.this.client.listCollections(ListCollectionsIterable.this.firstRequest);
            }
            return ListCollectionsIterable.this.client.listCollections((ListCollectionsRequest)((Object)ListCollectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

