/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.ActionType;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.ScheduleAt;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateScheduledActionRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, UpdateScheduledActionRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateScheduledActionRequest.getter(UpdateScheduledActionRequest::domainName)).setter(UpdateScheduledActionRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionID").getter(UpdateScheduledActionRequest.getter(UpdateScheduledActionRequest::actionID)).setter(UpdateScheduledActionRequest.setter(Builder::actionID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionID").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(UpdateScheduledActionRequest.getter(UpdateScheduledActionRequest::actionTypeAsString)).setter(UpdateScheduledActionRequest.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> SCHEDULE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleAt").getter(UpdateScheduledActionRequest.getter(UpdateScheduledActionRequest::scheduleAtAsString)).setter(UpdateScheduledActionRequest.setter(Builder::scheduleAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAt").build()}).build();
    private static final SdkField<Long> DESIRED_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DesiredStartTime").getter(UpdateScheduledActionRequest.getter(UpdateScheduledActionRequest::desiredStartTime)).setter(UpdateScheduledActionRequest.setter(Builder::desiredStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredStartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ACTION_ID_FIELD, ACTION_TYPE_FIELD, SCHEDULE_AT_FIELD, DESIRED_START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateScheduledActionRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String actionID;
    private final String actionType;
    private final String scheduleAt;
    private final Long desiredStartTime;

    private UpdateScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.actionID = builder.actionID;
        this.actionType = builder.actionType;
        this.scheduleAt = builder.scheduleAt;
        this.desiredStartTime = builder.desiredStartTime;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String actionID() {
        return this.actionID;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final ScheduleAt scheduleAt() {
        return ScheduleAt.fromValue(this.scheduleAt);
    }

    public final String scheduleAtAsString() {
        return this.scheduleAt;
    }

    public final Long desiredStartTime() {
        return this.desiredStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionID());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStartTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateScheduledActionRequest)) {
            return false;
        }
        UpdateScheduledActionRequest other = (UpdateScheduledActionRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.actionID(), other.actionID()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.scheduleAtAsString(), other.scheduleAtAsString()) && Objects.equals(this.desiredStartTime(), other.desiredStartTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateScheduledActionRequest").add("DomainName", (Object)this.domainName()).add("ActionID", (Object)this.actionID()).add("ActionType", (Object)this.actionTypeAsString()).add("ScheduleAt", (Object)this.scheduleAtAsString()).add("DesiredStartTime", (Object)this.desiredStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ActionID": {
                return Optional.ofNullable(clazz.cast(this.actionID()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "ScheduleAt": {
                return Optional.ofNullable(clazz.cast(this.scheduleAtAsString()));
            }
            case "DesiredStartTime": {
                return Optional.ofNullable(clazz.cast(this.desiredStartTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActionID", ACTION_ID_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("ScheduleAt", SCHEDULE_AT_FIELD);
        map.put("DesiredStartTime", DESIRED_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateScheduledActionRequest, T> g) {
        return obj -> g.apply((UpdateScheduledActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String actionID;
        private String actionType;
        private String scheduleAt;
        private Long desiredStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateScheduledActionRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.actionID(model.actionID);
            this.actionType(model.actionType);
            this.scheduleAt(model.scheduleAt);
            this.desiredStartTime(model.desiredStartTime);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getActionID() {
            return this.actionID;
        }

        public final void setActionID(String actionID) {
            this.actionID = actionID;
        }

        @Override
        public final Builder actionID(String actionID) {
            this.actionID = actionID;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getScheduleAt() {
            return this.scheduleAt;
        }

        public final void setScheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
        }

        @Override
        public final Builder scheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
            return this;
        }

        @Override
        public final Builder scheduleAt(ScheduleAt scheduleAt) {
            this.scheduleAt(scheduleAt == null ? null : scheduleAt.toString());
            return this;
        }

        public final Long getDesiredStartTime() {
            return this.desiredStartTime;
        }

        public final void setDesiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
        }

        @Override
        public final Builder desiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateScheduledActionRequest build() {
            return new UpdateScheduledActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateScheduledActionRequest> {
        public Builder domainName(String var1);

        public Builder actionID(String var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder scheduleAt(String var1);

        public Builder scheduleAt(ScheduleAt var1);

        public Builder desiredStartTime(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

