/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.NaturalLanguageQueryGenerationCurrentState;
import software.amazon.awssdk.services.opensearch.model.NaturalLanguageQueryGenerationDesiredState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NaturalLanguageQueryGenerationOptionsOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NaturalLanguageQueryGenerationOptionsOutput> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DesiredState").getter(NaturalLanguageQueryGenerationOptionsOutput.getter(NaturalLanguageQueryGenerationOptionsOutput::desiredStateAsString)).setter(NaturalLanguageQueryGenerationOptionsOutput.setter(Builder::desiredState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()}).build();
    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentState").getter(NaturalLanguageQueryGenerationOptionsOutput.getter(NaturalLanguageQueryGenerationOptionsOutput::currentStateAsString)).setter(NaturalLanguageQueryGenerationOptionsOutput.setter(Builder::currentState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD, CURRENT_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NaturalLanguageQueryGenerationOptionsOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String desiredState;
    private final String currentState;

    private NaturalLanguageQueryGenerationOptionsOutput(BuilderImpl builder) {
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
    }

    public final NaturalLanguageQueryGenerationDesiredState desiredState() {
        return NaturalLanguageQueryGenerationDesiredState.fromValue(this.desiredState);
    }

    public final String desiredStateAsString() {
        return this.desiredState;
    }

    public final NaturalLanguageQueryGenerationCurrentState currentState() {
        return NaturalLanguageQueryGenerationCurrentState.fromValue(this.currentState);
    }

    public final String currentStateAsString() {
        return this.currentState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NaturalLanguageQueryGenerationOptionsOutput)) {
            return false;
        }
        NaturalLanguageQueryGenerationOptionsOutput other = (NaturalLanguageQueryGenerationOptionsOutput)obj;
        return Objects.equals(this.desiredStateAsString(), other.desiredStateAsString()) && Objects.equals(this.currentStateAsString(), other.currentStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NaturalLanguageQueryGenerationOptionsOutput").add("DesiredState", (Object)this.desiredStateAsString()).add("CurrentState", (Object)this.currentStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DesiredState": {
                return Optional.ofNullable(clazz.cast(this.desiredStateAsString()));
            }
            case "CurrentState": {
                return Optional.ofNullable(clazz.cast(this.currentStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("CurrentState", CURRENT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NaturalLanguageQueryGenerationOptionsOutput, T> g) {
        return obj -> g.apply((NaturalLanguageQueryGenerationOptionsOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String desiredState;
        private String currentState;

        private BuilderImpl() {
        }

        private BuilderImpl(NaturalLanguageQueryGenerationOptionsOutput model) {
            this.desiredState(model.desiredState);
            this.currentState(model.currentState);
        }

        public final String getDesiredState() {
            return this.desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(NaturalLanguageQueryGenerationDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(NaturalLanguageQueryGenerationCurrentState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        public NaturalLanguageQueryGenerationOptionsOutput build() {
            return new NaturalLanguageQueryGenerationOptionsOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NaturalLanguageQueryGenerationOptionsOutput> {
        public Builder desiredState(String var1);

        public Builder desiredState(NaturalLanguageQueryGenerationDesiredState var1);

        public Builder currentState(String var1);

        public Builder currentState(NaturalLanguageQueryGenerationCurrentState var1);
    }
}

