/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.ValidationFailure;
import software.amazon.awssdk.services.opensearch.model.ValidationFailuresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DryRunProgressStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DryRunProgressStatus> {
    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DryRunId").getter(DryRunProgressStatus.getter(DryRunProgressStatus::dryRunId)).setter(DryRunProgressStatus.setter(Builder::dryRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunId").build()}).build();
    private static final SdkField<String> DRY_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DryRunStatus").getter(DryRunProgressStatus.getter(DryRunProgressStatus::dryRunStatus)).setter(DryRunProgressStatus.setter(Builder::dryRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunStatus").build()}).build();
    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationDate").getter(DryRunProgressStatus.getter(DryRunProgressStatus::creationDate)).setter(DryRunProgressStatus.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateDate").getter(DryRunProgressStatus.getter(DryRunProgressStatus::updateDate)).setter(DryRunProgressStatus.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").build()}).build();
    private static final SdkField<List<ValidationFailure>> VALIDATION_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidationFailures").getter(DryRunProgressStatus.getter(DryRunProgressStatus::validationFailures)).setter(DryRunProgressStatus.setter(Builder::validationFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_ID_FIELD, DRY_RUN_STATUS_FIELD, CREATION_DATE_FIELD, UPDATE_DATE_FIELD, VALIDATION_FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DryRunProgressStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dryRunId;
    private final String dryRunStatus;
    private final String creationDate;
    private final String updateDate;
    private final List<ValidationFailure> validationFailures;

    private DryRunProgressStatus(BuilderImpl builder) {
        this.dryRunId = builder.dryRunId;
        this.dryRunStatus = builder.dryRunStatus;
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
        this.validationFailures = builder.validationFailures;
    }

    public final String dryRunId() {
        return this.dryRunId;
    }

    public final String dryRunStatus() {
        return this.dryRunStatus;
    }

    public final String creationDate() {
        return this.creationDate;
    }

    public final String updateDate() {
        return this.updateDate;
    }

    public final boolean hasValidationFailures() {
        return this.validationFailures != null && !(this.validationFailures instanceof SdkAutoConstructList);
    }

    public final List<ValidationFailure> validationFailures() {
        return this.validationFailures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationFailures() ? this.validationFailures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DryRunProgressStatus)) {
            return false;
        }
        DryRunProgressStatus other = (DryRunProgressStatus)obj;
        return Objects.equals(this.dryRunId(), other.dryRunId()) && Objects.equals(this.dryRunStatus(), other.dryRunStatus()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.updateDate(), other.updateDate()) && this.hasValidationFailures() == other.hasValidationFailures() && Objects.equals(this.validationFailures(), other.validationFailures());
    }

    public final String toString() {
        return ToString.builder((String)"DryRunProgressStatus").add("DryRunId", (Object)this.dryRunId()).add("DryRunStatus", (Object)this.dryRunStatus()).add("CreationDate", (Object)this.creationDate()).add("UpdateDate", (Object)this.updateDate()).add("ValidationFailures", this.hasValidationFailures() ? this.validationFailures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRunId": {
                return Optional.ofNullable(clazz.cast(this.dryRunId()));
            }
            case "DryRunStatus": {
                return Optional.ofNullable(clazz.cast(this.dryRunStatus()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
            case "ValidationFailures": {
                return Optional.ofNullable(clazz.cast(this.validationFailures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRunId", DRY_RUN_ID_FIELD);
        map.put("DryRunStatus", DRY_RUN_STATUS_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("UpdateDate", UPDATE_DATE_FIELD);
        map.put("ValidationFailures", VALIDATION_FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DryRunProgressStatus, T> g) {
        return obj -> g.apply((DryRunProgressStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dryRunId;
        private String dryRunStatus;
        private String creationDate;
        private String updateDate;
        private List<ValidationFailure> validationFailures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DryRunProgressStatus model) {
            this.dryRunId(model.dryRunId);
            this.dryRunStatus(model.dryRunStatus);
            this.creationDate(model.creationDate);
            this.updateDate(model.updateDate);
            this.validationFailures(model.validationFailures);
        }

        public final String getDryRunId() {
            return this.dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        public final String getDryRunStatus() {
            return this.dryRunStatus;
        }

        public final void setDryRunStatus(String dryRunStatus) {
            this.dryRunStatus = dryRunStatus;
        }

        @Override
        public final Builder dryRunStatus(String dryRunStatus) {
            this.dryRunStatus = dryRunStatus;
            return this;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getUpdateDate() {
            return this.updateDate;
        }

        public final void setUpdateDate(String updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public final Builder updateDate(String updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final List<ValidationFailure.Builder> getValidationFailures() {
            List<ValidationFailure.Builder> result = ValidationFailuresCopier.copyToBuilder(this.validationFailures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationFailures(Collection<ValidationFailure.BuilderImpl> validationFailures) {
            this.validationFailures = ValidationFailuresCopier.copyFromBuilder(validationFailures);
        }

        @Override
        public final Builder validationFailures(Collection<ValidationFailure> validationFailures) {
            this.validationFailures = ValidationFailuresCopier.copy(validationFailures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationFailures(ValidationFailure ... validationFailures) {
            this.validationFailures(Arrays.asList(validationFailures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationFailures(Consumer<ValidationFailure.Builder> ... validationFailures) {
            this.validationFailures(Stream.of(validationFailures).map(c -> (ValidationFailure)((ValidationFailure.Builder)ValidationFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DryRunProgressStatus build() {
            return new DryRunProgressStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DryRunProgressStatus> {
        public Builder dryRunId(String var1);

        public Builder dryRunStatus(String var1);

        public Builder creationDate(String var1);

        public Builder updateDate(String var1);

        public Builder validationFailures(Collection<ValidationFailure> var1);

        public Builder validationFailures(ValidationFailure ... var1);

        public Builder validationFailures(Consumer<ValidationFailure.Builder> ... var1);
    }
}

