/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedInstanceOfferingRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, PurchaseReservedInstanceOfferingRequest> {
    private static final SdkField<String> RESERVED_INSTANCE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstanceOfferingId").getter(PurchaseReservedInstanceOfferingRequest.getter(PurchaseReservedInstanceOfferingRequest::reservedInstanceOfferingId)).setter(PurchaseReservedInstanceOfferingRequest.setter(Builder::reservedInstanceOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceOfferingId").build()}).build();
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(PurchaseReservedInstanceOfferingRequest.getter(PurchaseReservedInstanceOfferingRequest::reservationName)).setter(PurchaseReservedInstanceOfferingRequest.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(PurchaseReservedInstanceOfferingRequest.getter(PurchaseReservedInstanceOfferingRequest::instanceCount)).setter(PurchaseReservedInstanceOfferingRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_INSTANCE_OFFERING_ID_FIELD, RESERVATION_NAME_FIELD, INSTANCE_COUNT_FIELD));
    private final String reservedInstanceOfferingId;
    private final String reservationName;
    private final Integer instanceCount;

    private PurchaseReservedInstanceOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstanceOfferingId = builder.reservedInstanceOfferingId;
        this.reservationName = builder.reservationName;
        this.instanceCount = builder.instanceCount;
    }

    public final String reservedInstanceOfferingId() {
        return this.reservedInstanceOfferingId;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstanceOfferingRequest)) {
            return false;
        }
        PurchaseReservedInstanceOfferingRequest other = (PurchaseReservedInstanceOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedInstanceOfferingId(), other.reservedInstanceOfferingId()) && Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.instanceCount(), other.instanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedInstanceOfferingRequest").add("ReservedInstanceOfferingId", (Object)this.reservedInstanceOfferingId()).add("ReservationName", (Object)this.reservationName()).add("InstanceCount", (Object)this.instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceOfferingId()));
            }
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedInstanceOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedInstanceOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String reservedInstanceOfferingId;
        private String reservationName;
        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstanceOfferingRequest model) {
            super(model);
            this.reservedInstanceOfferingId(model.reservedInstanceOfferingId);
            this.reservationName(model.reservationName);
            this.instanceCount(model.instanceCount);
        }

        public final String getReservedInstanceOfferingId() {
            return this.reservedInstanceOfferingId;
        }

        public final void setReservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
        }

        @Override
        public final Builder reservedInstanceOfferingId(String reservedInstanceOfferingId) {
            this.reservedInstanceOfferingId = reservedInstanceOfferingId;
            return this;
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedInstanceOfferingRequest build() {
            return new PurchaseReservedInstanceOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedInstanceOfferingRequest> {
        public Builder reservedInstanceOfferingId(String var1);

        public Builder reservationName(String var1);

        public Builder instanceCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

