/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.services.opensearch.model.InstanceRoleListCopier;
import software.amazon.awssdk.services.opensearch.model.OpenSearchPartitionInstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTypeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTypeDetails> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceTypeDetails.getter(InstanceTypeDetails::instanceTypeAsString)).setter(InstanceTypeDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EncryptionEnabled").getter(InstanceTypeDetails.getter(InstanceTypeDetails::encryptionEnabled)).setter(InstanceTypeDetails.setter(Builder::encryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionEnabled").build()}).build();
    private static final SdkField<Boolean> COGNITO_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CognitoEnabled").getter(InstanceTypeDetails.getter(InstanceTypeDetails::cognitoEnabled)).setter(InstanceTypeDetails.setter(Builder::cognitoEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoEnabled").build()}).build();
    private static final SdkField<Boolean> APP_LOGS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AppLogsEnabled").getter(InstanceTypeDetails.getter(InstanceTypeDetails::appLogsEnabled)).setter(InstanceTypeDetails.setter(Builder::appLogsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppLogsEnabled").build()}).build();
    private static final SdkField<Boolean> ADVANCED_SECURITY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdvancedSecurityEnabled").getter(InstanceTypeDetails.getter(InstanceTypeDetails::advancedSecurityEnabled)).setter(InstanceTypeDetails.setter(Builder::advancedSecurityEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityEnabled").build()}).build();
    private static final SdkField<Boolean> WARM_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WarmEnabled").getter(InstanceTypeDetails.getter(InstanceTypeDetails::warmEnabled)).setter(InstanceTypeDetails.setter(Builder::warmEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmEnabled").build()}).build();
    private static final SdkField<List<String>> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceRole").getter(InstanceTypeDetails.getter(InstanceTypeDetails::instanceRole)).setter(InstanceTypeDetails.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRole").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(InstanceTypeDetails.getter(InstanceTypeDetails::availabilityZones)).setter(InstanceTypeDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, ENCRYPTION_ENABLED_FIELD, COGNITO_ENABLED_FIELD, APP_LOGS_ENABLED_FIELD, ADVANCED_SECURITY_ENABLED_FIELD, WARM_ENABLED_FIELD, INSTANCE_ROLE_FIELD, AVAILABILITY_ZONES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Boolean encryptionEnabled;
    private final Boolean cognitoEnabled;
    private final Boolean appLogsEnabled;
    private final Boolean advancedSecurityEnabled;
    private final Boolean warmEnabled;
    private final List<String> instanceRole;
    private final List<String> availabilityZones;

    private InstanceTypeDetails(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.encryptionEnabled = builder.encryptionEnabled;
        this.cognitoEnabled = builder.cognitoEnabled;
        this.appLogsEnabled = builder.appLogsEnabled;
        this.advancedSecurityEnabled = builder.advancedSecurityEnabled;
        this.warmEnabled = builder.warmEnabled;
        this.instanceRole = builder.instanceRole;
        this.availabilityZones = builder.availabilityZones;
    }

    public final OpenSearchPartitionInstanceType instanceType() {
        return OpenSearchPartitionInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Boolean encryptionEnabled() {
        return this.encryptionEnabled;
    }

    public final Boolean cognitoEnabled() {
        return this.cognitoEnabled;
    }

    public final Boolean appLogsEnabled() {
        return this.appLogsEnabled;
    }

    public final Boolean advancedSecurityEnabled() {
        return this.advancedSecurityEnabled;
    }

    public final Boolean warmEnabled() {
        return this.warmEnabled;
    }

    public final boolean hasInstanceRole() {
        return this.instanceRole != null && !(this.instanceRole instanceof SdkAutoConstructList);
    }

    public final List<String> instanceRole() {
        return this.instanceRole;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.appLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceRole() ? this.instanceRole() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeDetails)) {
            return false;
        }
        InstanceTypeDetails other = (InstanceTypeDetails)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.encryptionEnabled(), other.encryptionEnabled()) && Objects.equals(this.cognitoEnabled(), other.cognitoEnabled()) && Objects.equals(this.appLogsEnabled(), other.appLogsEnabled()) && Objects.equals(this.advancedSecurityEnabled(), other.advancedSecurityEnabled()) && Objects.equals(this.warmEnabled(), other.warmEnabled()) && this.hasInstanceRole() == other.hasInstanceRole() && Objects.equals(this.instanceRole(), other.instanceRole()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTypeDetails").add("InstanceType", (Object)this.instanceTypeAsString()).add("EncryptionEnabled", (Object)this.encryptionEnabled()).add("CognitoEnabled", (Object)this.cognitoEnabled()).add("AppLogsEnabled", (Object)this.appLogsEnabled()).add("AdvancedSecurityEnabled", (Object)this.advancedSecurityEnabled()).add("WarmEnabled", (Object)this.warmEnabled()).add("InstanceRole", this.hasInstanceRole() ? this.instanceRole() : null).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "EncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.encryptionEnabled()));
            }
            case "CognitoEnabled": {
                return Optional.ofNullable(clazz.cast(this.cognitoEnabled()));
            }
            case "AppLogsEnabled": {
                return Optional.ofNullable(clazz.cast(this.appLogsEnabled()));
            }
            case "AdvancedSecurityEnabled": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityEnabled()));
            }
            case "WarmEnabled": {
                return Optional.ofNullable(clazz.cast(this.warmEnabled()));
            }
            case "InstanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRole()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeDetails, T> g) {
        return obj -> g.apply((InstanceTypeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Boolean encryptionEnabled;
        private Boolean cognitoEnabled;
        private Boolean appLogsEnabled;
        private Boolean advancedSecurityEnabled;
        private Boolean warmEnabled;
        private List<String> instanceRole = DefaultSdkAutoConstructList.getInstance();
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeDetails model) {
            this.instanceType(model.instanceType);
            this.encryptionEnabled(model.encryptionEnabled);
            this.cognitoEnabled(model.cognitoEnabled);
            this.appLogsEnabled(model.appLogsEnabled);
            this.advancedSecurityEnabled(model.advancedSecurityEnabled);
            this.warmEnabled(model.warmEnabled);
            this.instanceRole(model.instanceRole);
            this.availabilityZones(model.availabilityZones);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(OpenSearchPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Boolean getEncryptionEnabled() {
            return this.encryptionEnabled;
        }

        public final void setEncryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
        }

        @Override
        public final Builder encryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
            return this;
        }

        public final Boolean getCognitoEnabled() {
            return this.cognitoEnabled;
        }

        public final void setCognitoEnabled(Boolean cognitoEnabled) {
            this.cognitoEnabled = cognitoEnabled;
        }

        @Override
        public final Builder cognitoEnabled(Boolean cognitoEnabled) {
            this.cognitoEnabled = cognitoEnabled;
            return this;
        }

        public final Boolean getAppLogsEnabled() {
            return this.appLogsEnabled;
        }

        public final void setAppLogsEnabled(Boolean appLogsEnabled) {
            this.appLogsEnabled = appLogsEnabled;
        }

        @Override
        public final Builder appLogsEnabled(Boolean appLogsEnabled) {
            this.appLogsEnabled = appLogsEnabled;
            return this;
        }

        public final Boolean getAdvancedSecurityEnabled() {
            return this.advancedSecurityEnabled;
        }

        public final void setAdvancedSecurityEnabled(Boolean advancedSecurityEnabled) {
            this.advancedSecurityEnabled = advancedSecurityEnabled;
        }

        @Override
        public final Builder advancedSecurityEnabled(Boolean advancedSecurityEnabled) {
            this.advancedSecurityEnabled = advancedSecurityEnabled;
            return this;
        }

        public final Boolean getWarmEnabled() {
            return this.warmEnabled;
        }

        public final void setWarmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
        }

        @Override
        public final Builder warmEnabled(Boolean warmEnabled) {
            this.warmEnabled = warmEnabled;
            return this;
        }

        public final Collection<String> getInstanceRole() {
            if (this.instanceRole instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceRole;
        }

        public final void setInstanceRole(Collection<String> instanceRole) {
            this.instanceRole = InstanceRoleListCopier.copy(instanceRole);
        }

        @Override
        public final Builder instanceRole(Collection<String> instanceRole) {
            this.instanceRole = InstanceRoleListCopier.copy(instanceRole);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceRole(String ... instanceRole) {
            this.instanceRole(Arrays.asList(instanceRole));
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public InstanceTypeDetails build() {
            return new InstanceTypeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTypeDetails> {
        public Builder instanceType(String var1);

        public Builder instanceType(OpenSearchPartitionInstanceType var1);

        public Builder encryptionEnabled(Boolean var1);

        public Builder cognitoEnabled(Boolean var1);

        public Builder appLogsEnabled(Boolean var1);

        public Builder advancedSecurityEnabled(Boolean var1);

        public Builder warmEnabled(Boolean var1);

        public Builder instanceRole(Collection<String> var1);

        public Builder instanceRole(String ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);
    }
}

