/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsRequest;
import software.amazon.awssdk.services.opensearch.model.ListScheduledActionsResponse;

public class ListScheduledActionsIterable
implements SdkIterable<ListScheduledActionsResponse> {
    private final OpenSearchClient client;
    private final ListScheduledActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScheduledActionsIterable(OpenSearchClient client, ListScheduledActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListScheduledActionsResponseFetcher();
    }

    public Iterator<ListScheduledActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListScheduledActionsResponseFetcher
    implements SyncPageFetcher<ListScheduledActionsResponse> {
        private ListScheduledActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScheduledActionsResponse nextPage(ListScheduledActionsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledActionsIterable.this.client.listScheduledActions(ListScheduledActionsIterable.this.firstRequest);
            }
            return ListScheduledActionsIterable.this.client.listScheduledActions((ListScheduledActionsRequest)((Object)ListScheduledActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

