/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ImageMapping;
import software.amazon.awssdk.services.omics.model.ImageMappingsListCopier;
import software.amazon.awssdk.services.omics.model.RegistryMapping;
import software.amazon.awssdk.services.omics.model.RegistryMappingsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerRegistryMap
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerRegistryMap> {
    private static final SdkField<List<RegistryMapping>> REGISTRY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("registryMappings").getter(ContainerRegistryMap.getter(ContainerRegistryMap::registryMappings)).setter(ContainerRegistryMap.setter(Builder::registryMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RegistryMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ImageMapping>> IMAGE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageMappings").getter(ContainerRegistryMap.getter(ContainerRegistryMap::imageMappings)).setter(ContainerRegistryMap.setter(Builder::imageMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_MAPPINGS_FIELD, IMAGE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerRegistryMap.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RegistryMapping> registryMappings;
    private final List<ImageMapping> imageMappings;

    private ContainerRegistryMap(BuilderImpl builder) {
        this.registryMappings = builder.registryMappings;
        this.imageMappings = builder.imageMappings;
    }

    public final boolean hasRegistryMappings() {
        return this.registryMappings != null && !(this.registryMappings instanceof SdkAutoConstructList);
    }

    public final List<RegistryMapping> registryMappings() {
        return this.registryMappings;
    }

    public final boolean hasImageMappings() {
        return this.imageMappings != null && !(this.imageMappings instanceof SdkAutoConstructList);
    }

    public final List<ImageMapping> imageMappings() {
        return this.imageMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegistryMappings() ? this.registryMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageMappings() ? this.imageMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRegistryMap)) {
            return false;
        }
        ContainerRegistryMap other = (ContainerRegistryMap)obj;
        return this.hasRegistryMappings() == other.hasRegistryMappings() && Objects.equals(this.registryMappings(), other.registryMappings()) && this.hasImageMappings() == other.hasImageMappings() && Objects.equals(this.imageMappings(), other.imageMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerRegistryMap").add("RegistryMappings", this.hasRegistryMappings() ? this.registryMappings() : null).add("ImageMappings", this.hasImageMappings() ? this.imageMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryMappings": {
                return Optional.ofNullable(clazz.cast(this.registryMappings()));
            }
            case "imageMappings": {
                return Optional.ofNullable(clazz.cast(this.imageMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registryMappings", REGISTRY_MAPPINGS_FIELD);
        map.put("imageMappings", IMAGE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerRegistryMap, T> g) {
        return obj -> g.apply((ContainerRegistryMap)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RegistryMapping> registryMappings = DefaultSdkAutoConstructList.getInstance();
        private List<ImageMapping> imageMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRegistryMap model) {
            this.registryMappings(model.registryMappings);
            this.imageMappings(model.imageMappings);
        }

        public final List<RegistryMapping.Builder> getRegistryMappings() {
            List<RegistryMapping.Builder> result = RegistryMappingsListCopier.copyToBuilder(this.registryMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistryMappings(Collection<RegistryMapping.BuilderImpl> registryMappings) {
            this.registryMappings = RegistryMappingsListCopier.copyFromBuilder(registryMappings);
        }

        @Override
        public final Builder registryMappings(Collection<RegistryMapping> registryMappings) {
            this.registryMappings = RegistryMappingsListCopier.copy(registryMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registryMappings(RegistryMapping ... registryMappings) {
            this.registryMappings(Arrays.asList(registryMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registryMappings(Consumer<RegistryMapping.Builder> ... registryMappings) {
            this.registryMappings(Stream.of(registryMappings).map(c -> (RegistryMapping)((RegistryMapping.Builder)RegistryMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ImageMapping.Builder> getImageMappings() {
            List<ImageMapping.Builder> result = ImageMappingsListCopier.copyToBuilder(this.imageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageMappings(Collection<ImageMapping.BuilderImpl> imageMappings) {
            this.imageMappings = ImageMappingsListCopier.copyFromBuilder(imageMappings);
        }

        @Override
        public final Builder imageMappings(Collection<ImageMapping> imageMappings) {
            this.imageMappings = ImageMappingsListCopier.copy(imageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageMappings(ImageMapping ... imageMappings) {
            this.imageMappings(Arrays.asList(imageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageMappings(Consumer<ImageMapping.Builder> ... imageMappings) {
            this.imageMappings(Stream.of(imageMappings).map(c -> (ImageMapping)((ImageMapping.Builder)ImageMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ContainerRegistryMap build() {
            return new ContainerRegistryMap(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerRegistryMap> {
        public Builder registryMappings(Collection<RegistryMapping> var1);

        public Builder registryMappings(RegistryMapping ... var1);

        public Builder registryMappings(Consumer<RegistryMapping.Builder> ... var1);

        public Builder imageMappings(Collection<ImageMapping> var1);

        public Builder imageMappings(ImageMapping ... var1);

        public Builder imageMappings(Consumer<ImageMapping.Builder> ... var1);
    }
}

