/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.ReadSetPartSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadReadSetPartRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, UploadReadSetPartRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(UploadReadSetPartRequest.getter(UploadReadSetPartRequest::sequenceStoreId)).setter(UploadReadSetPartRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(UploadReadSetPartRequest.getter(UploadReadSetPartRequest::uploadId)).setter(UploadReadSetPartRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()}).build();
    private static final SdkField<String> PART_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partSource").getter(UploadReadSetPartRequest.getter(UploadReadSetPartRequest::partSourceAsString)).setter(UploadReadSetPartRequest.setter(Builder::partSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partSource").build()}).build();
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("partNumber").getter(UploadReadSetPartRequest.getter(UploadReadSetPartRequest::partNumber)).setter(UploadReadSetPartRequest.setter(Builder::partNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD, UPLOAD_ID_FIELD, PART_SOURCE_FIELD, PART_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UploadReadSetPartRequest.memberNameToFieldInitializer();
    private final String sequenceStoreId;
    private final String uploadId;
    private final String partSource;
    private final Integer partNumber;

    private UploadReadSetPartRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.partSource = builder.partSource;
        this.partNumber = builder.partNumber;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final ReadSetPartSource partSource() {
        return ReadSetPartSource.fromValue(this.partSource);
    }

    public final String partSourceAsString() {
        return this.partSource;
    }

    public final Integer partNumber() {
        return this.partNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadReadSetPartRequest)) {
            return false;
        }
        UploadReadSetPartRequest other = (UploadReadSetPartRequest)((Object)obj);
        return Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.partSourceAsString(), other.partSourceAsString()) && Objects.equals(this.partNumber(), other.partNumber());
    }

    public final String toString() {
        return ToString.builder((String)"UploadReadSetPartRequest").add("SequenceStoreId", (Object)this.sequenceStoreId()).add("UploadId", (Object)this.uploadId()).add("PartSource", (Object)this.partSourceAsString()).add("PartNumber", (Object)this.partNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "partSource": {
                return Optional.ofNullable(clazz.cast(this.partSourceAsString()));
            }
            case "partNumber": {
                return Optional.ofNullable(clazz.cast(this.partNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("partSource", PART_SOURCE_FIELD);
        map.put("partNumber", PART_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadReadSetPartRequest, T> g) {
        return obj -> g.apply((UploadReadSetPartRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String sequenceStoreId;
        private String uploadId;
        private String partSource;
        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadReadSetPartRequest model) {
            super(model);
            this.sequenceStoreId(model.sequenceStoreId);
            this.uploadId(model.uploadId);
            this.partSource(model.partSource);
            this.partNumber(model.partNumber);
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getPartSource() {
            return this.partSource;
        }

        public final void setPartSource(String partSource) {
            this.partSource = partSource;
        }

        @Override
        public final Builder partSource(String partSource) {
            this.partSource = partSource;
            return this;
        }

        @Override
        public final Builder partSource(ReadSetPartSource partSource) {
            this.partSource(partSource == null ? null : partSource.toString());
            return this;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadReadSetPartRequest build() {
            return new UploadReadSetPartRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UploadReadSetPartRequest> {
        public Builder sequenceStoreId(String var1);

        public Builder uploadId(String var1);

        public Builder partSource(String var1);

        public Builder partSource(ReadSetPartSource var1);

        public Builder partNumber(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

