/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.ETagAlgorithmFamily;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.PropagatedSetLevelTagsCopier;
import software.amazon.awssdk.services.omics.model.S3AccessConfig;
import software.amazon.awssdk.services.omics.model.SseConfig;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSequenceStoreRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateSequenceStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::name)).setter(CreateSequenceStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::description)).setter(CreateSequenceStoreRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sseConfig").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::sseConfig)).setter(CreateSequenceStoreRequest.setter(Builder::sseConfig)).constructor(SseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::tags)).setter(CreateSequenceStoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::clientToken)).setter(CreateSequenceStoreRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FALLBACK_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fallbackLocation").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::fallbackLocation)).setter(CreateSequenceStoreRequest.setter(Builder::fallbackLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackLocation").build()}).build();
    private static final SdkField<String> E_TAG_ALGORITHM_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eTagAlgorithmFamily").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::eTagAlgorithmFamilyAsString)).setter(CreateSequenceStoreRequest.setter(Builder::eTagAlgorithmFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTagAlgorithmFamily").build()}).build();
    private static final SdkField<List<String>> PROPAGATED_SET_LEVEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propagatedSetLevelTags").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::propagatedSetLevelTags)).setter(CreateSequenceStoreRequest.setter(Builder::propagatedSetLevelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatedSetLevelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3AccessConfig> S3_ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3AccessConfig").getter(CreateSequenceStoreRequest.getter(CreateSequenceStoreRequest::s3AccessConfig)).setter(CreateSequenceStoreRequest.setter(Builder::s3AccessConfig)).constructor(S3AccessConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SSE_CONFIG_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, FALLBACK_LOCATION_FIELD, E_TAG_ALGORITHM_FAMILY_FIELD, PROPAGATED_SET_LEVEL_TAGS_FIELD, S3_ACCESS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSequenceStoreRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final SseConfig sseConfig;
    private final Map<String, String> tags;
    private final String clientToken;
    private final String fallbackLocation;
    private final String eTagAlgorithmFamily;
    private final List<String> propagatedSetLevelTags;
    private final S3AccessConfig s3AccessConfig;

    private CreateSequenceStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.fallbackLocation = builder.fallbackLocation;
        this.eTagAlgorithmFamily = builder.eTagAlgorithmFamily;
        this.propagatedSetLevelTags = builder.propagatedSetLevelTags;
        this.s3AccessConfig = builder.s3AccessConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final SseConfig sseConfig() {
        return this.sseConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String fallbackLocation() {
        return this.fallbackLocation;
    }

    public final ETagAlgorithmFamily eTagAlgorithmFamily() {
        return ETagAlgorithmFamily.fromValue(this.eTagAlgorithmFamily);
    }

    public final String eTagAlgorithmFamilyAsString() {
        return this.eTagAlgorithmFamily;
    }

    public final boolean hasPropagatedSetLevelTags() {
        return this.propagatedSetLevelTags != null && !(this.propagatedSetLevelTags instanceof SdkAutoConstructList);
    }

    public final List<String> propagatedSetLevelTags() {
        return this.propagatedSetLevelTags;
    }

    public final S3AccessConfig s3AccessConfig() {
        return this.s3AccessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTagAlgorithmFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropagatedSetLevelTags() ? this.propagatedSetLevelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3AccessConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSequenceStoreRequest)) {
            return false;
        }
        CreateSequenceStoreRequest other = (CreateSequenceStoreRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sseConfig(), other.sseConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.fallbackLocation(), other.fallbackLocation()) && Objects.equals(this.eTagAlgorithmFamilyAsString(), other.eTagAlgorithmFamilyAsString()) && this.hasPropagatedSetLevelTags() == other.hasPropagatedSetLevelTags() && Objects.equals(this.propagatedSetLevelTags(), other.propagatedSetLevelTags()) && Objects.equals(this.s3AccessConfig(), other.s3AccessConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSequenceStoreRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SseConfig", (Object)this.sseConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("FallbackLocation", (Object)this.fallbackLocation()).add("ETagAlgorithmFamily", (Object)this.eTagAlgorithmFamilyAsString()).add("PropagatedSetLevelTags", this.hasPropagatedSetLevelTags() ? this.propagatedSetLevelTags() : null).add("S3AccessConfig", (Object)this.s3AccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sseConfig": {
                return Optional.ofNullable(clazz.cast(this.sseConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "fallbackLocation": {
                return Optional.ofNullable(clazz.cast(this.fallbackLocation()));
            }
            case "eTagAlgorithmFamily": {
                return Optional.ofNullable(clazz.cast(this.eTagAlgorithmFamilyAsString()));
            }
            case "propagatedSetLevelTags": {
                return Optional.ofNullable(clazz.cast(this.propagatedSetLevelTags()));
            }
            case "s3AccessConfig": {
                return Optional.ofNullable(clazz.cast(this.s3AccessConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sseConfig", SSE_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("fallbackLocation", FALLBACK_LOCATION_FIELD);
        map.put("eTagAlgorithmFamily", E_TAG_ALGORITHM_FAMILY_FIELD);
        map.put("propagatedSetLevelTags", PROPAGATED_SET_LEVEL_TAGS_FIELD);
        map.put("s3AccessConfig", S3_ACCESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSequenceStoreRequest, T> g) {
        return obj -> g.apply((CreateSequenceStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private SseConfig sseConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private String fallbackLocation;
        private String eTagAlgorithmFamily;
        private List<String> propagatedSetLevelTags = DefaultSdkAutoConstructList.getInstance();
        private S3AccessConfig s3AccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSequenceStoreRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.sseConfig(model.sseConfig);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.fallbackLocation(model.fallbackLocation);
            this.eTagAlgorithmFamily(model.eTagAlgorithmFamily);
            this.propagatedSetLevelTags(model.propagatedSetLevelTags);
            this.s3AccessConfig(model.s3AccessConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return this.sseConfig != null ? this.sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFallbackLocation() {
            return this.fallbackLocation;
        }

        public final void setFallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
        }

        @Override
        public final Builder fallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        public final String getETagAlgorithmFamily() {
            return this.eTagAlgorithmFamily;
        }

        public final void setETagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
        }

        @Override
        public final Builder eTagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
            return this;
        }

        @Override
        public final Builder eTagAlgorithmFamily(ETagAlgorithmFamily eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily(eTagAlgorithmFamily == null ? null : eTagAlgorithmFamily.toString());
            return this;
        }

        public final Collection<String> getPropagatedSetLevelTags() {
            if (this.propagatedSetLevelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propagatedSetLevelTags;
        }

        public final void setPropagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
        }

        @Override
        public final Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatedSetLevelTags(String ... propagatedSetLevelTags) {
            this.propagatedSetLevelTags(Arrays.asList(propagatedSetLevelTags));
            return this;
        }

        public final S3AccessConfig.Builder getS3AccessConfig() {
            return this.s3AccessConfig != null ? this.s3AccessConfig.toBuilder() : null;
        }

        public final void setS3AccessConfig(S3AccessConfig.BuilderImpl s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig != null ? s3AccessConfig.build() : null;
        }

        @Override
        public final Builder s3AccessConfig(S3AccessConfig s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSequenceStoreRequest build() {
            return new CreateSequenceStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSequenceStoreRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder sseConfig(SseConfig var1);

        default public Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return this.sseConfig((SseConfig)((SseConfig.Builder)SseConfig.builder().applyMutation(sseConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder fallbackLocation(String var1);

        public Builder eTagAlgorithmFamily(String var1);

        public Builder eTagAlgorithmFamily(ETagAlgorithmFamily var1);

        public Builder propagatedSetLevelTags(Collection<String> var1);

        public Builder propagatedSetLevelTags(String ... var1);

        public Builder s3AccessConfig(S3AccessConfig var1);

        default public Builder s3AccessConfig(Consumer<S3AccessConfig.Builder> s3AccessConfig) {
            return this.s3AccessConfig((S3AccessConfig)((S3AccessConfig.Builder)S3AccessConfig.builder().applyMutation(s3AccessConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

