/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequestSourcesListCopier;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobSourceItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReadSetActivationJobRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartReadSetActivationJobRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(StartReadSetActivationJobRequest.getter(StartReadSetActivationJobRequest::sequenceStoreId)).setter(StartReadSetActivationJobRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartReadSetActivationJobRequest.getter(StartReadSetActivationJobRequest::clientToken)).setter(StartReadSetActivationJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<List<StartReadSetActivationJobSourceItem>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(StartReadSetActivationJobRequest.getter(StartReadSetActivationJobRequest::sources)).setter(StartReadSetActivationJobRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartReadSetActivationJobSourceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD, CLIENT_TOKEN_FIELD, SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartReadSetActivationJobRequest.memberNameToFieldInitializer();
    private final String sequenceStoreId;
    private final String clientToken;
    private final List<StartReadSetActivationJobSourceItem> sources;

    private StartReadSetActivationJobRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.clientToken = builder.clientToken;
        this.sources = builder.sources;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<StartReadSetActivationJobSourceItem> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReadSetActivationJobRequest)) {
            return false;
        }
        StartReadSetActivationJobRequest other = (StartReadSetActivationJobRequest)((Object)obj);
        return Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"StartReadSetActivationJobRequest").add("SequenceStoreId", (Object)this.sequenceStoreId()).add("ClientToken", (Object)this.clientToken()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("sources", SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartReadSetActivationJobRequest, T> g) {
        return obj -> g.apply((StartReadSetActivationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String sequenceStoreId;
        private String clientToken;
        private List<StartReadSetActivationJobSourceItem> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReadSetActivationJobRequest model) {
            super(model);
            this.sequenceStoreId(model.sequenceStoreId);
            this.clientToken(model.clientToken);
            this.sources(model.sources);
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<StartReadSetActivationJobSourceItem.Builder> getSources() {
            List<StartReadSetActivationJobSourceItem.Builder> result = StartReadSetActivationJobRequestSourcesListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<StartReadSetActivationJobSourceItem.BuilderImpl> sources) {
            this.sources = StartReadSetActivationJobRequestSourcesListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<StartReadSetActivationJobSourceItem> sources) {
            this.sources = StartReadSetActivationJobRequestSourcesListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(StartReadSetActivationJobSourceItem ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<StartReadSetActivationJobSourceItem.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (StartReadSetActivationJobSourceItem)((StartReadSetActivationJobSourceItem.Builder)StartReadSetActivationJobSourceItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReadSetActivationJobRequest build() {
            return new StartReadSetActivationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReadSetActivationJobRequest> {
        public Builder sequenceStoreId(String var1);

        public Builder clientToken(String var1);

        public Builder sources(Collection<StartReadSetActivationJobSourceItem> var1);

        public Builder sources(StartReadSetActivationJobSourceItem ... var1);

        public Builder sources(Consumer<StartReadSetActivationJobSourceItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

