/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.FileType;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultipartReadSetUploadRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateMultipartReadSetUploadRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::sequenceStoreId)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::clientToken)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFileType").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::sourceFileTypeAsString)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::sourceFileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()}).build();
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subjectId").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::subjectId)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::subjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()}).build();
    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleId").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::sampleId)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::sampleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()}).build();
    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedFrom").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::generatedFrom)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::generatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()}).build();
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceArn").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::referenceArn)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::referenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::name)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::description)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMultipartReadSetUploadRequest.getter(CreateMultipartReadSetUploadRequest::tags)).setter(CreateMultipartReadSetUploadRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD, CLIENT_TOKEN_FIELD, SOURCE_FILE_TYPE_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, GENERATED_FROM_FIELD, REFERENCE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMultipartReadSetUploadRequest.memberNameToFieldInitializer();
    private final String sequenceStoreId;
    private final String clientToken;
    private final String sourceFileType;
    private final String subjectId;
    private final String sampleId;
    private final String generatedFrom;
    private final String referenceArn;
    private final String name;
    private final String description;
    private final Map<String, String> tags;

    private CreateMultipartReadSetUploadRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.clientToken = builder.clientToken;
        this.sourceFileType = builder.sourceFileType;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.generatedFrom = builder.generatedFrom;
        this.referenceArn = builder.referenceArn;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final FileType sourceFileType() {
        return FileType.fromValue(this.sourceFileType);
    }

    public final String sourceFileTypeAsString() {
        return this.sourceFileType;
    }

    public final String subjectId() {
        return this.subjectId;
    }

    public final String sampleId() {
        return this.sampleId;
    }

    public final String generatedFrom() {
        return this.generatedFrom;
    }

    public final String referenceArn() {
        return this.referenceArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultipartReadSetUploadRequest)) {
            return false;
        }
        CreateMultipartReadSetUploadRequest other = (CreateMultipartReadSetUploadRequest)((Object)obj);
        return Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sourceFileTypeAsString(), other.sourceFileTypeAsString()) && Objects.equals(this.subjectId(), other.subjectId()) && Objects.equals(this.sampleId(), other.sampleId()) && Objects.equals(this.generatedFrom(), other.generatedFrom()) && Objects.equals(this.referenceArn(), other.referenceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMultipartReadSetUploadRequest").add("SequenceStoreId", (Object)this.sequenceStoreId()).add("ClientToken", (Object)this.clientToken()).add("SourceFileType", (Object)this.sourceFileTypeAsString()).add("SubjectId", (Object)this.subjectId()).add("SampleId", (Object)this.sampleId()).add("GeneratedFrom", (Object)this.generatedFrom()).add("ReferenceArn", (Object)this.referenceArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "sourceFileType": {
                return Optional.ofNullable(clazz.cast(this.sourceFileTypeAsString()));
            }
            case "subjectId": {
                return Optional.ofNullable(clazz.cast(this.subjectId()));
            }
            case "sampleId": {
                return Optional.ofNullable(clazz.cast(this.sampleId()));
            }
            case "generatedFrom": {
                return Optional.ofNullable(clazz.cast(this.generatedFrom()));
            }
            case "referenceArn": {
                return Optional.ofNullable(clazz.cast(this.referenceArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("sourceFileType", SOURCE_FILE_TYPE_FIELD);
        map.put("subjectId", SUBJECT_ID_FIELD);
        map.put("sampleId", SAMPLE_ID_FIELD);
        map.put("generatedFrom", GENERATED_FROM_FIELD);
        map.put("referenceArn", REFERENCE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultipartReadSetUploadRequest, T> g) {
        return obj -> g.apply((CreateMultipartReadSetUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String sequenceStoreId;
        private String clientToken;
        private String sourceFileType;
        private String subjectId;
        private String sampleId;
        private String generatedFrom;
        private String referenceArn;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultipartReadSetUploadRequest model) {
            super(model);
            this.sequenceStoreId(model.sequenceStoreId);
            this.clientToken(model.clientToken);
            this.sourceFileType(model.sourceFileType);
            this.subjectId(model.subjectId);
            this.sampleId(model.sampleId);
            this.generatedFrom(model.generatedFrom);
            this.referenceArn(model.referenceArn);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceFileType() {
            return this.sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final String getSubjectId() {
            return this.subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return this.sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getGeneratedFrom() {
            return this.generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getReferenceArn() {
            return this.referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultipartReadSetUploadRequest build() {
            return new CreateMultipartReadSetUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMultipartReadSetUploadRequest> {
        public Builder sequenceStoreId(String var1);

        public Builder clientToken(String var1);

        public Builder sourceFileType(String var1);

        public Builder sourceFileType(FileType var1);

        public Builder subjectId(String var1);

        public Builder sampleId(String var1);

        public Builder generatedFrom(String var1);

        public Builder referenceArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

