/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.Accelerators;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowEngine;
import software.amazon.awssdk.services.omics.model.WorkflowMetadataCopier;
import software.amazon.awssdk.services.omics.model.WorkflowParameter;
import software.amazon.awssdk.services.omics.model.WorkflowParameterTemplateCopier;
import software.amazon.awssdk.services.omics.model.WorkflowStatus;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetWorkflowResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetWorkflowResponse.getter(GetWorkflowResponse::arn)).setter(GetWorkflowResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetWorkflowResponse.getter(GetWorkflowResponse::id)).setter(GetWorkflowResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowResponse.getter(GetWorkflowResponse::statusAsString)).setter(GetWorkflowResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetWorkflowResponse.getter(GetWorkflowResponse::typeAsString)).setter(GetWorkflowResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetWorkflowResponse.getter(GetWorkflowResponse::name)).setter(GetWorkflowResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetWorkflowResponse.getter(GetWorkflowResponse::description)).setter(GetWorkflowResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(GetWorkflowResponse.getter(GetWorkflowResponse::engineAsString)).setter(GetWorkflowResponse.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(GetWorkflowResponse.getter(GetWorkflowResponse::definition)).setter(GetWorkflowResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> MAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("main").getter(GetWorkflowResponse.getter(GetWorkflowResponse::main)).setter(GetWorkflowResponse.setter(Builder::main)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()}).build();
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("digest").getter(GetWorkflowResponse.getter(GetWorkflowResponse::digest)).setter(GetWorkflowResponse.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()}).build();
    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameterTemplate").getter(GetWorkflowResponse.getter(GetWorkflowResponse::parameterTemplate)).setter(GetWorkflowResponse.setter(Builder::parameterTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(GetWorkflowResponse.getter(GetWorkflowResponse::storageCapacity)).setter(GetWorkflowResponse.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetWorkflowResponse.getter(GetWorkflowResponse::creationTime)).setter(GetWorkflowResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetWorkflowResponse.getter(GetWorkflowResponse::statusMessage)).setter(GetWorkflowResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetWorkflowResponse.getter(GetWorkflowResponse::tags)).setter(GetWorkflowResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(GetWorkflowResponse.getter(GetWorkflowResponse::metadata)).setter(GetWorkflowResponse.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accelerators").getter(GetWorkflowResponse.getter(GetWorkflowResponse::acceleratorsAsString)).setter(GetWorkflowResponse.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, STATUS_FIELD, TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, DEFINITION_FIELD, MAIN_FIELD, DIGEST_FIELD, PARAMETER_TEMPLATE_FIELD, STORAGE_CAPACITY_FIELD, CREATION_TIME_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD, METADATA_FIELD, ACCELERATORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String id;
    private final String status;
    private final String type;
    private final String name;
    private final String description;
    private final String engine;
    private final String definition;
    private final String main;
    private final String digest;
    private final Map<String, WorkflowParameter> parameterTemplate;
    private final Integer storageCapacity;
    private final Instant creationTime;
    private final String statusMessage;
    private final Map<String, String> tags;
    private final Map<String, String> metadata;
    private final String accelerators;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.engine = builder.engine;
        this.definition = builder.definition;
        this.main = builder.main;
        this.digest = builder.digest;
        this.parameterTemplate = builder.parameterTemplate;
        this.storageCapacity = builder.storageCapacity;
        this.creationTime = builder.creationTime;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.metadata = builder.metadata;
        this.accelerators = builder.accelerators;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final WorkflowType type() {
        return WorkflowType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final String definition() {
        return this.definition;
    }

    public final String main() {
        return this.main;
    }

    public final String digest() {
        return this.digest;
    }

    public final boolean hasParameterTemplate() {
        return this.parameterTemplate != null && !(this.parameterTemplate instanceof SdkAutoConstructMap);
    }

    public final Map<String, WorkflowParameter> parameterTemplate() {
        return this.parameterTemplate;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final Accelerators accelerators() {
        return Accelerators.fromValue(this.accelerators);
    }

    public final String acceleratorsAsString() {
        return this.accelerators;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.main());
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterTemplate() ? this.parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.main(), other.main()) && Objects.equals(this.digest(), other.digest()) && this.hasParameterTemplate() == other.hasParameterTemplate() && Objects.equals(this.parameterTemplate(), other.parameterTemplate()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.acceleratorsAsString(), other.acceleratorsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Engine", (Object)this.engineAsString()).add("Definition", (Object)this.definition()).add("Main", (Object)this.main()).add("Digest", (Object)this.digest()).add("ParameterTemplate", this.hasParameterTemplate() ? this.parameterTemplate() : null).add("StorageCapacity", (Object)this.storageCapacity()).add("CreationTime", (Object)this.creationTime()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("Accelerators", (Object)this.acceleratorsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "main": {
                return Optional.ofNullable(clazz.cast(this.main()));
            }
            case "digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "parameterTemplate": {
                return Optional.ofNullable(clazz.cast(this.parameterTemplate()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "accelerators": {
                return Optional.ofNullable(clazz.cast(this.acceleratorsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("main", MAIN_FIELD);
        map.put("digest", DIGEST_FIELD);
        map.put("parameterTemplate", PARAMETER_TEMPLATE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("accelerators", ACCELERATORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String status;
        private String type;
        private String name;
        private String description;
        private String engine;
        private String definition;
        private String main;
        private String digest;
        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();
        private Integer storageCapacity;
        private Instant creationTime;
        private String statusMessage;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private String accelerators;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.status(model.status);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.engine(model.engine);
            this.definition(model.definition);
            this.main(model.main);
            this.digest(model.digest);
            this.parameterTemplate(model.parameterTemplate);
            this.storageCapacity(model.storageCapacity);
            this.creationTime(model.creationTime);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
            this.metadata(model.metadata);
            this.accelerators(model.accelerators);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getMain() {
            return this.main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = WorkflowMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = WorkflowMetadataCopier.copy(metadata);
            return this;
        }

        public final String getAccelerators() {
            return this.accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(WorkflowStatus var1);

        public Builder type(String var1);

        public Builder type(WorkflowType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder engine(WorkflowEngine var1);

        public Builder definition(String var1);

        public Builder main(String var1);

        public Builder digest(String var1);

        public Builder parameterTemplate(Map<String, WorkflowParameter> var1);

        public Builder storageCapacity(Integer var1);

        public Builder creationTime(Instant var1);

        public Builder statusMessage(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder metadata(Map<String, String> var1);

        public Builder accelerators(String var1);

        public Builder accelerators(Accelerators var1);
    }
}

