/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkflowType {
    PRIVATE("PRIVATE"),
    READY2_RUN("READY2RUN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkflowType> VALUE_MAP;
    private final String value;

    private WorkflowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowType> knownValues() {
        EnumSet<WorkflowType> knownValues = EnumSet.allOf(WorkflowType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkflowType.class, WorkflowType::toString);
    }
}

