/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkflowVersionsRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, ListWorkflowVersionsRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(ListWorkflowVersionsRequest.getter(ListWorkflowVersionsRequest::workflowId)).setter(ListWorkflowVersionsRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowId").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ListWorkflowVersionsRequest.getter(ListWorkflowVersionsRequest::typeAsString)).setter(ListWorkflowVersionsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowOwnerId").getter(ListWorkflowVersionsRequest.getter(ListWorkflowVersionsRequest::workflowOwnerId)).setter(ListWorkflowVersionsRequest.setter(Builder::workflowOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("workflowOwnerId").build()}).build();
    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startingToken").getter(ListWorkflowVersionsRequest.getter(ListWorkflowVersionsRequest::startingToken)).setter(ListWorkflowVersionsRequest.setter(Builder::startingToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListWorkflowVersionsRequest.getter(ListWorkflowVersionsRequest::maxResults)).setter(ListWorkflowVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, TYPE_FIELD, WORKFLOW_OWNER_ID_FIELD, STARTING_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkflowVersionsRequest.memberNameToFieldInitializer();
    private final String workflowId;
    private final String type;
    private final String workflowOwnerId;
    private final String startingToken;
    private final Integer maxResults;

    private ListWorkflowVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.type = builder.type;
        this.workflowOwnerId = builder.workflowOwnerId;
        this.startingToken = builder.startingToken;
        this.maxResults = builder.maxResults;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final WorkflowType type() {
        return WorkflowType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String workflowOwnerId() {
        return this.workflowOwnerId;
    }

    public final String startingToken() {
        return this.startingToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowVersionsRequest)) {
            return false;
        }
        ListWorkflowVersionsRequest other = (ListWorkflowVersionsRequest)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.workflowOwnerId(), other.workflowOwnerId()) && Objects.equals(this.startingToken(), other.startingToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkflowVersionsRequest").add("WorkflowId", (Object)this.workflowId()).add("Type", (Object)this.typeAsString()).add("WorkflowOwnerId", (Object)this.workflowOwnerId()).add("StartingToken", (Object)this.startingToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "workflowOwnerId": {
                return Optional.ofNullable(clazz.cast(this.workflowOwnerId()));
            }
            case "startingToken": {
                return Optional.ofNullable(clazz.cast(this.startingToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("workflowOwnerId", WORKFLOW_OWNER_ID_FIELD);
        map.put("startingToken", STARTING_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowVersionsRequest, T> g) {
        return obj -> g.apply((ListWorkflowVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String workflowId;
        private String type;
        private String workflowOwnerId;
        private String startingToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowVersionsRequest model) {
            super(model);
            this.workflowId(model.workflowId);
            this.type(model.type);
            this.workflowOwnerId(model.workflowOwnerId);
            this.startingToken(model.startingToken);
            this.maxResults(model.maxResults);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getWorkflowOwnerId() {
            return this.workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        public final String getStartingToken() {
            return this.startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkflowVersionsRequest build() {
            return new ListWorkflowVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkflowVersionsRequest> {
        public Builder workflowId(String var1);

        public Builder type(String var1);

        public Builder type(WorkflowType var1);

        public Builder workflowOwnerId(String var1);

        public Builder startingToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

