/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SequenceInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SequenceInformation> {
    private static final SdkField<Long> TOTAL_READ_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalReadCount").getter(SequenceInformation.getter(SequenceInformation::totalReadCount)).setter(SequenceInformation.setter(Builder::totalReadCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalReadCount").build()}).build();
    private static final SdkField<Long> TOTAL_BASE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalBaseCount").getter(SequenceInformation.getter(SequenceInformation::totalBaseCount)).setter(SequenceInformation.setter(Builder::totalBaseCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBaseCount").build()}).build();
    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedFrom").getter(SequenceInformation.getter(SequenceInformation::generatedFrom)).setter(SequenceInformation.setter(Builder::generatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()}).build();
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alignment").getter(SequenceInformation.getter(SequenceInformation::alignment)).setter(SequenceInformation.setter(Builder::alignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_READ_COUNT_FIELD, TOTAL_BASE_COUNT_FIELD, GENERATED_FROM_FIELD, ALIGNMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SequenceInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long totalReadCount;
    private final Long totalBaseCount;
    private final String generatedFrom;
    private final String alignment;

    private SequenceInformation(BuilderImpl builder) {
        this.totalReadCount = builder.totalReadCount;
        this.totalBaseCount = builder.totalBaseCount;
        this.generatedFrom = builder.generatedFrom;
        this.alignment = builder.alignment;
    }

    public final Long totalReadCount() {
        return this.totalReadCount;
    }

    public final Long totalBaseCount() {
        return this.totalBaseCount;
    }

    public final String generatedFrom() {
        return this.generatedFrom;
    }

    public final String alignment() {
        return this.alignment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalReadCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBaseCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.alignment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceInformation)) {
            return false;
        }
        SequenceInformation other = (SequenceInformation)obj;
        return Objects.equals(this.totalReadCount(), other.totalReadCount()) && Objects.equals(this.totalBaseCount(), other.totalBaseCount()) && Objects.equals(this.generatedFrom(), other.generatedFrom()) && Objects.equals(this.alignment(), other.alignment());
    }

    public final String toString() {
        return ToString.builder((String)"SequenceInformation").add("TotalReadCount", (Object)this.totalReadCount()).add("TotalBaseCount", (Object)this.totalBaseCount()).add("GeneratedFrom", (Object)this.generatedFrom()).add("Alignment", (Object)this.alignment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "totalReadCount": {
                return Optional.ofNullable(clazz.cast(this.totalReadCount()));
            }
            case "totalBaseCount": {
                return Optional.ofNullable(clazz.cast(this.totalBaseCount()));
            }
            case "generatedFrom": {
                return Optional.ofNullable(clazz.cast(this.generatedFrom()));
            }
            case "alignment": {
                return Optional.ofNullable(clazz.cast(this.alignment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("totalReadCount", TOTAL_READ_COUNT_FIELD);
        map.put("totalBaseCount", TOTAL_BASE_COUNT_FIELD);
        map.put("generatedFrom", GENERATED_FROM_FIELD);
        map.put("alignment", ALIGNMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SequenceInformation, T> g) {
        return obj -> g.apply((SequenceInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalReadCount;
        private Long totalBaseCount;
        private String generatedFrom;
        private String alignment;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceInformation model) {
            this.totalReadCount(model.totalReadCount);
            this.totalBaseCount(model.totalBaseCount);
            this.generatedFrom(model.generatedFrom);
            this.alignment(model.alignment);
        }

        public final Long getTotalReadCount() {
            return this.totalReadCount;
        }

        public final void setTotalReadCount(Long totalReadCount) {
            this.totalReadCount = totalReadCount;
        }

        @Override
        public final Builder totalReadCount(Long totalReadCount) {
            this.totalReadCount = totalReadCount;
            return this;
        }

        public final Long getTotalBaseCount() {
            return this.totalBaseCount;
        }

        public final void setTotalBaseCount(Long totalBaseCount) {
            this.totalBaseCount = totalBaseCount;
        }

        @Override
        public final Builder totalBaseCount(Long totalBaseCount) {
            this.totalBaseCount = totalBaseCount;
            return this;
        }

        public final String getGeneratedFrom() {
            return this.generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        public SequenceInformation build() {
            return new SequenceInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SequenceInformation> {
        public Builder totalReadCount(Long var1);

        public Builder totalBaseCount(Long var1);

        public Builder generatedFrom(String var1);

        public Builder alignment(String var1);
    }
}

