/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.SseConfig;
import software.amazon.awssdk.services.omics.model.StoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VariantStoreItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VariantStoreItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(VariantStoreItem.getter(VariantStoreItem::id)).setter(VariantStoreItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(VariantStoreItem.getter(VariantStoreItem::reference)).setter(VariantStoreItem.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(VariantStoreItem.getter(VariantStoreItem::statusAsString)).setter(VariantStoreItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeArn").getter(VariantStoreItem.getter(VariantStoreItem::storeArn)).setter(VariantStoreItem.setter(Builder::storeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(VariantStoreItem.getter(VariantStoreItem::name)).setter(VariantStoreItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(VariantStoreItem.getter(VariantStoreItem::description)).setter(VariantStoreItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sseConfig").getter(VariantStoreItem.getter(VariantStoreItem::sseConfig)).setter(VariantStoreItem.setter(Builder::sseConfig)).constructor(SseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(VariantStoreItem.getter(VariantStoreItem::creationTime)).setter(VariantStoreItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(VariantStoreItem.getter(VariantStoreItem::updateTime)).setter(VariantStoreItem.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(VariantStoreItem.getter(VariantStoreItem::statusMessage)).setter(VariantStoreItem.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Long> STORE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storeSizeBytes").getter(VariantStoreItem.getter(VariantStoreItem::storeSizeBytes)).setter(VariantStoreItem.setter(Builder::storeSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeSizeBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REFERENCE_FIELD, STATUS_FIELD, STORE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SSE_CONFIG_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD, STATUS_MESSAGE_FIELD, STORE_SIZE_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VariantStoreItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final ReferenceItem reference;
    private final String status;
    private final String storeArn;
    private final String name;
    private final String description;
    private final SseConfig sseConfig;
    private final Instant creationTime;
    private final Instant updateTime;
    private final String statusMessage;
    private final Long storeSizeBytes;

    private VariantStoreItem(BuilderImpl builder) {
        this.id = builder.id;
        this.reference = builder.reference;
        this.status = builder.status;
        this.storeArn = builder.storeArn;
        this.name = builder.name;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.statusMessage = builder.statusMessage;
        this.storeSizeBytes = builder.storeSizeBytes;
    }

    public final String id() {
        return this.id;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final StoreStatus status() {
        return StoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String storeArn() {
        return this.storeArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final SseConfig sseConfig() {
        return this.sseConfig;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Long storeSizeBytes() {
        return this.storeSizeBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeSizeBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariantStoreItem)) {
            return false;
        }
        VariantStoreItem other = (VariantStoreItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.storeArn(), other.storeArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sseConfig(), other.sseConfig()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.storeSizeBytes(), other.storeSizeBytes());
    }

    public final String toString() {
        return ToString.builder((String)"VariantStoreItem").add("Id", (Object)this.id()).add("Reference", (Object)this.reference()).add("Status", (Object)this.statusAsString()).add("StoreArn", (Object)this.storeArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SseConfig", (Object)this.sseConfig()).add("CreationTime", (Object)this.creationTime()).add("UpdateTime", (Object)this.updateTime()).add("StatusMessage", (Object)this.statusMessage()).add("StoreSizeBytes", (Object)this.storeSizeBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "storeArn": {
                return Optional.ofNullable(clazz.cast(this.storeArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sseConfig": {
                return Optional.ofNullable(clazz.cast(this.sseConfig()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "storeSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.storeSizeBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("reference", REFERENCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("storeArn", STORE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sseConfig", SSE_CONFIG_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("storeSizeBytes", STORE_SIZE_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VariantStoreItem, T> g) {
        return obj -> g.apply((VariantStoreItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private ReferenceItem reference;
        private String status;
        private String storeArn;
        private String name;
        private String description;
        private SseConfig sseConfig;
        private Instant creationTime;
        private Instant updateTime;
        private String statusMessage;
        private Long storeSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(VariantStoreItem model) {
            this.id(model.id);
            this.reference(model.reference);
            this.status(model.status);
            this.storeArn(model.storeArn);
            this.name(model.name);
            this.description(model.description);
            this.sseConfig(model.sseConfig);
            this.creationTime(model.creationTime);
            this.updateTime(model.updateTime);
            this.statusMessage(model.statusMessage);
            this.storeSizeBytes(model.storeSizeBytes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStoreArn() {
            return this.storeArn;
        }

        public final void setStoreArn(String storeArn) {
            this.storeArn = storeArn;
        }

        @Override
        public final Builder storeArn(String storeArn) {
            this.storeArn = storeArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return this.sseConfig != null ? this.sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getStoreSizeBytes() {
            return this.storeSizeBytes;
        }

        public final void setStoreSizeBytes(Long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
        }

        @Override
        public final Builder storeSizeBytes(Long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
            return this;
        }

        public VariantStoreItem build() {
            return new VariantStoreItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VariantStoreItem> {
        public Builder id(String var1);

        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder status(String var1);

        public Builder status(StoreStatus var1);

        public Builder storeArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder sseConfig(SseConfig var1);

        default public Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return this.sseConfig((SseConfig)((SseConfig.Builder)SseConfig.builder().applyMutation(sseConfig)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder statusMessage(String var1);

        public Builder storeSizeBytes(Long var1);
    }
}

