/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.VariantStoreItem;
import software.amazon.awssdk.services.omics.model.VariantStoreItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVariantStoresResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListVariantStoresResponse> {
    private static final SdkField<List<VariantStoreItem>> VARIANT_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variantStores").getter(ListVariantStoresResponse.getter(ListVariantStoresResponse::variantStores)).setter(ListVariantStoresResponse.setter(Builder::variantStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariantStoreItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVariantStoresResponse.getter(ListVariantStoresResponse::nextToken)).setter(ListVariantStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_STORES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("variantStores", VARIANT_STORES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<VariantStoreItem> variantStores;
    private final String nextToken;

    private ListVariantStoresResponse(BuilderImpl builder) {
        super(builder);
        this.variantStores = builder.variantStores;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVariantStores() {
        return this.variantStores != null && !(this.variantStores instanceof SdkAutoConstructList);
    }

    public final List<VariantStoreItem> variantStores() {
        return this.variantStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariantStores() ? this.variantStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVariantStoresResponse)) {
            return false;
        }
        ListVariantStoresResponse other = (ListVariantStoresResponse)((Object)obj);
        return this.hasVariantStores() == other.hasVariantStores() && Objects.equals(this.variantStores(), other.variantStores()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVariantStoresResponse").add("VariantStores", this.hasVariantStores() ? this.variantStores() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variantStores": {
                return Optional.ofNullable(clazz.cast(this.variantStores()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListVariantStoresResponse, T> g) {
        return obj -> g.apply((ListVariantStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private List<VariantStoreItem> variantStores = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVariantStoresResponse model) {
            super(model);
            this.variantStores(model.variantStores);
            this.nextToken(model.nextToken);
        }

        public final List<VariantStoreItem.Builder> getVariantStores() {
            List<VariantStoreItem.Builder> result = VariantStoreItemsCopier.copyToBuilder(this.variantStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariantStores(Collection<VariantStoreItem.BuilderImpl> variantStores) {
            this.variantStores = VariantStoreItemsCopier.copyFromBuilder(variantStores);
        }

        @Override
        public final Builder variantStores(Collection<VariantStoreItem> variantStores) {
            this.variantStores = VariantStoreItemsCopier.copy(variantStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStores(VariantStoreItem ... variantStores) {
            this.variantStores(Arrays.asList(variantStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStores(Consumer<VariantStoreItem.Builder> ... variantStores) {
            this.variantStores(Stream.of(variantStores).map(c -> (VariantStoreItem)((VariantStoreItem.Builder)VariantStoreItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVariantStoresResponse build() {
            return new ListVariantStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVariantStoresResponse> {
        public Builder variantStores(Collection<VariantStoreItem> var1);

        public Builder variantStores(VariantStoreItem ... var1);

        public Builder variantStores(Consumer<VariantStoreItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

