/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ImportReadSetJobItem;
import software.amazon.awssdk.services.omics.model.ImportReadSetJobListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReadSetImportJobsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListReadSetImportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReadSetImportJobsResponse.getter(ListReadSetImportJobsResponse::nextToken)).setter(ListReadSetImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ImportReadSetJobItem>> IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("importJobs").getter(ListReadSetImportJobsResponse.getter(ListReadSetImportJobsResponse::importJobs)).setter(ListReadSetImportJobsResponse.setter(Builder::importJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportReadSetJobItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IMPORT_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("importJobs", IMPORT_JOBS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ImportReadSetJobItem> importJobs;

    private ListReadSetImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.importJobs = builder.importJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasImportJobs() {
        return this.importJobs != null && !(this.importJobs instanceof SdkAutoConstructList);
    }

    public final List<ImportReadSetJobItem> importJobs() {
        return this.importJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportJobs() ? this.importJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetImportJobsResponse)) {
            return false;
        }
        ListReadSetImportJobsResponse other = (ListReadSetImportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasImportJobs() == other.hasImportJobs() && Objects.equals(this.importJobs(), other.importJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListReadSetImportJobsResponse").add("NextToken", (Object)this.nextToken()).add("ImportJobs", this.hasImportJobs() ? this.importJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "importJobs": {
                return Optional.ofNullable(clazz.cast(this.importJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetImportJobsResponse, T> g) {
        return obj -> g.apply((ListReadSetImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ImportReadSetJobItem> importJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetImportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.importJobs(model.importJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImportReadSetJobItem.Builder> getImportJobs() {
            List<ImportReadSetJobItem.Builder> result = ImportReadSetJobListCopier.copyToBuilder(this.importJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobs(Collection<ImportReadSetJobItem.BuilderImpl> importJobs) {
            this.importJobs = ImportReadSetJobListCopier.copyFromBuilder(importJobs);
        }

        @Override
        public final Builder importJobs(Collection<ImportReadSetJobItem> importJobs) {
            this.importJobs = ImportReadSetJobListCopier.copy(importJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(ImportReadSetJobItem ... importJobs) {
            this.importJobs(Arrays.asList(importJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobs(Consumer<ImportReadSetJobItem.Builder> ... importJobs) {
            this.importJobs(Stream.of(importJobs).map(c -> (ImportReadSetJobItem)((ImportReadSetJobItem.Builder)ImportReadSetJobItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetImportJobsResponse build() {
            return new ListReadSetImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReadSetImportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder importJobs(Collection<ImportReadSetJobItem> var1);

        public Builder importJobs(ImportReadSetJobItem ... var1);

        public Builder importJobs(Consumer<ImportReadSetJobItem.Builder> ... var1);
    }
}

