/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.AnnotationImportJobItem;
import software.amazon.awssdk.services.omics.model.AnnotationImportJobItemsCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnnotationImportJobsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListAnnotationImportJobsResponse> {
    private static final SdkField<List<AnnotationImportJobItem>> ANNOTATION_IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("annotationImportJobs").getter(ListAnnotationImportJobsResponse.getter(ListAnnotationImportJobsResponse::annotationImportJobs)).setter(ListAnnotationImportJobsResponse.setter(Builder::annotationImportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnnotationImportJobItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnnotationImportJobsResponse.getter(ListAnnotationImportJobsResponse::nextToken)).setter(ListAnnotationImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_IMPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("annotationImportJobs", ANNOTATION_IMPORT_JOBS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AnnotationImportJobItem> annotationImportJobs;
    private final String nextToken;

    private ListAnnotationImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.annotationImportJobs = builder.annotationImportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnnotationImportJobs() {
        return this.annotationImportJobs != null && !(this.annotationImportJobs instanceof SdkAutoConstructList);
    }

    public final List<AnnotationImportJobItem> annotationImportJobs() {
        return this.annotationImportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotationImportJobs() ? this.annotationImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnnotationImportJobsResponse)) {
            return false;
        }
        ListAnnotationImportJobsResponse other = (ListAnnotationImportJobsResponse)((Object)obj);
        return this.hasAnnotationImportJobs() == other.hasAnnotationImportJobs() && Objects.equals(this.annotationImportJobs(), other.annotationImportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnnotationImportJobsResponse").add("AnnotationImportJobs", this.hasAnnotationImportJobs() ? this.annotationImportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "annotationImportJobs": {
                return Optional.ofNullable(clazz.cast(this.annotationImportJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAnnotationImportJobsResponse, T> g) {
        return obj -> g.apply((ListAnnotationImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private List<AnnotationImportJobItem> annotationImportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnnotationImportJobsResponse model) {
            super(model);
            this.annotationImportJobs(model.annotationImportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<AnnotationImportJobItem.Builder> getAnnotationImportJobs() {
            List<AnnotationImportJobItem.Builder> result = AnnotationImportJobItemsCopier.copyToBuilder(this.annotationImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotationImportJobs(Collection<AnnotationImportJobItem.BuilderImpl> annotationImportJobs) {
            this.annotationImportJobs = AnnotationImportJobItemsCopier.copyFromBuilder(annotationImportJobs);
        }

        @Override
        public final Builder annotationImportJobs(Collection<AnnotationImportJobItem> annotationImportJobs) {
            this.annotationImportJobs = AnnotationImportJobItemsCopier.copy(annotationImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationImportJobs(AnnotationImportJobItem ... annotationImportJobs) {
            this.annotationImportJobs(Arrays.asList(annotationImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotationImportJobs(Consumer<AnnotationImportJobItem.Builder> ... annotationImportJobs) {
            this.annotationImportJobs(Stream.of(annotationImportJobs).map(c -> (AnnotationImportJobItem)((AnnotationImportJobItem.Builder)AnnotationImportJobItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnnotationImportJobsResponse build() {
            return new ListAnnotationImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnnotationImportJobsResponse> {
        public Builder annotationImportJobs(Collection<AnnotationImportJobItem> var1);

        public Builder annotationImportJobs(AnnotationImportJobItem ... var1);

        public Builder annotationImportJobs(Consumer<AnnotationImportJobItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

