/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.CacheBehavior;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.RunCacheStatus;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunCacheResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetRunCacheResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetRunCacheResponse.getter(GetRunCacheResponse::arn)).setter(GetRunCacheResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheBehavior").getter(GetRunCacheResponse.getter(GetRunCacheResponse::cacheBehaviorAsString)).setter(GetRunCacheResponse.setter(Builder::cacheBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()}).build();
    private static final SdkField<String> CACHE_BUCKET_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheBucketOwnerId").getter(GetRunCacheResponse.getter(GetRunCacheResponse::cacheBucketOwnerId)).setter(GetRunCacheResponse.setter(Builder::cacheBucketOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBucketOwnerId").build()}).build();
    private static final SdkField<String> CACHE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheS3Uri").getter(GetRunCacheResponse.getter(GetRunCacheResponse::cacheS3Uri)).setter(GetRunCacheResponse.setter(Builder::cacheS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Uri").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRunCacheResponse.getter(GetRunCacheResponse::creationTime)).setter(GetRunCacheResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetRunCacheResponse.getter(GetRunCacheResponse::description)).setter(GetRunCacheResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetRunCacheResponse.getter(GetRunCacheResponse::id)).setter(GetRunCacheResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRunCacheResponse.getter(GetRunCacheResponse::name)).setter(GetRunCacheResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetRunCacheResponse.getter(GetRunCacheResponse::statusAsString)).setter(GetRunCacheResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetRunCacheResponse.getter(GetRunCacheResponse::tags)).setter(GetRunCacheResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CACHE_BEHAVIOR_FIELD, CACHE_BUCKET_OWNER_ID_FIELD, CACHE_S3_URI_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
            this.put("cacheBucketOwnerId", CACHE_BUCKET_OWNER_ID_FIELD);
            this.put("cacheS3Uri", CACHE_S3_URI_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String arn;
    private final String cacheBehavior;
    private final String cacheBucketOwnerId;
    private final String cacheS3Uri;
    private final Instant creationTime;
    private final String description;
    private final String id;
    private final String name;
    private final String status;
    private final Map<String, String> tags;

    private GetRunCacheResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cacheBehavior = builder.cacheBehavior;
        this.cacheBucketOwnerId = builder.cacheBucketOwnerId;
        this.cacheS3Uri = builder.cacheS3Uri;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(this.cacheBehavior);
    }

    public final String cacheBehaviorAsString() {
        return this.cacheBehavior;
    }

    public final String cacheBucketOwnerId() {
        return this.cacheBucketOwnerId;
    }

    public final String cacheS3Uri() {
        return this.cacheS3Uri;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final RunCacheStatus status() {
        return RunCacheStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBucketOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunCacheResponse)) {
            return false;
        }
        GetRunCacheResponse other = (GetRunCacheResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cacheBehaviorAsString(), other.cacheBehaviorAsString()) && Objects.equals(this.cacheBucketOwnerId(), other.cacheBucketOwnerId()) && Objects.equals(this.cacheS3Uri(), other.cacheS3Uri()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunCacheResponse").add("Arn", (Object)this.arn()).add("CacheBehavior", (Object)this.cacheBehaviorAsString()).add("CacheBucketOwnerId", (Object)this.cacheBucketOwnerId()).add("CacheS3Uri", (Object)this.cacheS3Uri()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "cacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorAsString()));
            }
            case "cacheBucketOwnerId": {
                return Optional.ofNullable(clazz.cast(this.cacheBucketOwnerId()));
            }
            case "cacheS3Uri": {
                return Optional.ofNullable(clazz.cast(this.cacheS3Uri()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRunCacheResponse, T> g) {
        return obj -> g.apply((GetRunCacheResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String cacheBehavior;
        private String cacheBucketOwnerId;
        private String cacheS3Uri;
        private Instant creationTime;
        private String description;
        private String id;
        private String name;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunCacheResponse model) {
            super(model);
            this.arn(model.arn);
            this.cacheBehavior(model.cacheBehavior);
            this.cacheBucketOwnerId(model.cacheBucketOwnerId);
            this.cacheS3Uri(model.cacheS3Uri);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCacheBehavior() {
            return this.cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getCacheBucketOwnerId() {
            return this.cacheBucketOwnerId;
        }

        public final void setCacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
        }

        @Override
        public final Builder cacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
            return this;
        }

        public final String getCacheS3Uri() {
            return this.cacheS3Uri;
        }

        public final void setCacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
        }

        @Override
        public final Builder cacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunCacheStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetRunCacheResponse build() {
            return new GetRunCacheResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunCacheResponse> {
        public Builder arn(String var1);

        public Builder cacheBehavior(String var1);

        public Builder cacheBehavior(CacheBehavior var1);

        public Builder cacheBucketOwnerId(String var1);

        public Builder cacheS3Uri(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(RunCacheStatus var1);

        public Builder tags(Map<String, String> var1);
    }
}

